/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import io.debezium.connector.cassandra.exceptions.CassandraConnectorSchemaException;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.cassandra.db.marshal.AbstractType;

public final class CassandraTypeToAvroSchemaMapper {
    public static final Schema STRING_TYPE = (Schema)SchemaBuilder.builder().stringType();
    public static final Schema BOOLEAN_TYPE = (Schema)SchemaBuilder.builder().booleanType();
    public static final Schema BYTES_TYPE = (Schema)SchemaBuilder.builder().bytesType();
    public static final Schema INT_TYPE = (Schema)SchemaBuilder.builder().intType();
    public static final Schema FLOAT_TYPE = (Schema)SchemaBuilder.builder().floatType();
    public static final Schema DOUBLE_TYPE = (Schema)SchemaBuilder.builder().doubleType();
    public static final Schema LONG_TYPE = (Schema)SchemaBuilder.builder().longType();
    public static final Schema DATE_TYPE = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
    public static final Schema TIMESTAMP_MILLI_TYPE = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    public static final Schema TIMESTAMP_MICRO_TYPE = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    public static final Schema UUID_TYPE = (Schema)SchemaBuilder.builder().fixed("UUID").size(16);
    public static final Schema DURATION_TYPE = (Schema)SchemaBuilder.record((String)"duration").fields().requiredInt("months").requiredInt("days").requiredInt("nanos").endRecord();

    private CassandraTypeToAvroSchemaMapper() {
    }

    public static Schema nullable(Schema schema) {
        return (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.builder().unionOf().nullType()).and().type(schema)).endUnion();
    }

    public static Schema getSchema(AbstractType<?> type, boolean nullable) {
        Schema requiredSchema;
        try {
            requiredSchema = CassandraTypeDeserializer.getSchema(type);
        }
        catch (NullPointerException e) {
            throw new CassandraConnectorSchemaException("Unknown data type: " + type);
        }
        if (nullable) {
            return CassandraTypeToAvroSchemaMapper.nullable(requiredSchema);
        }
        return requiredSchema;
    }
}

