/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import com.datastax.driver.core.DataType;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import io.debezium.connector.cassandra.transforms.type.deserializer.BasicTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.DurationTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.InetAddressDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.ListTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.MapTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.SetTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TimeUUIDTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TimestampTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TupleTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.UUIDTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.UserTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;

public final class CassandraTypeDeserializer {
    private static final Map<Class<? extends AbstractType>, TypeDeserializer> typeMap = new HashMap<Class<? extends AbstractType>, TypeDeserializer>();

    private CassandraTypeDeserializer() {
    }

    public static Object deserialize(DataType dataType, ByteBuffer bb) {
        AbstractType<?> abstractType = CassandraTypeConverter.convert(dataType);
        return CassandraTypeDeserializer.deserialize(abstractType, bb);
    }

    public static Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        TypeDeserializer typeDeserializer = typeMap.get(abstractType.getClass());
        return typeDeserializer.deserialize(abstractType, bb);
    }

    public static Schema getSchema(AbstractType<?> abstractType) {
        TypeDeserializer typeDeserializer = typeMap.get(abstractType.getClass());
        return typeDeserializer.getSchema(abstractType);
    }

    static {
        typeMap.put(AsciiType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.STRING_TYPE));
        typeMap.put(BooleanType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.BOOLEAN_TYPE));
        typeMap.put(BytesType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.BYTES_TYPE));
        typeMap.put(ByteType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.INT_TYPE));
        typeMap.put(CounterColumnType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.LONG_TYPE));
        typeMap.put(DecimalType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.DOUBLE_TYPE));
        typeMap.put(DoubleType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.DOUBLE_TYPE));
        typeMap.put(DurationType.class, new DurationTypeDeserializer());
        typeMap.put(FloatType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.FLOAT_TYPE));
        typeMap.put(InetAddressType.class, new InetAddressDeserializer());
        typeMap.put(Int32Type.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.INT_TYPE));
        typeMap.put(ListType.class, new ListTypeDeserializer());
        typeMap.put(LongType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.LONG_TYPE));
        typeMap.put(MapType.class, new MapTypeDeserializer());
        typeMap.put(SetType.class, new SetTypeDeserializer());
        typeMap.put(ShortType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.INT_TYPE));
        typeMap.put(SimpleDateType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.DATE_TYPE));
        typeMap.put(TimeType.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.LONG_TYPE));
        typeMap.put(TimestampType.class, new TimestampTypeDeserializer());
        typeMap.put(TimeUUIDType.class, new TimeUUIDTypeDeserializer());
        typeMap.put(TupleType.class, new TupleTypeDeserializer());
        typeMap.put(UserType.class, new UserTypeDeserializer());
        typeMap.put(UTF8Type.class, new BasicTypeDeserializer(CassandraTypeToAvroSchemaMapper.STRING_TYPE));
        typeMap.put(UUIDType.class, new UUIDTypeDeserializer());
    }
}

