/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.network;

import io.debezium.connector.cassandra.exceptions.CassandraConnectorConfigException;
import io.debezium.connector.cassandra.network.SslConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class SslContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslContextFactory.class);

    private SslContextFactory() {
    }

    public static SslContext createSslContext(String sslConfigPath) throws GeneralSecurityException, IOException {
        if (sslConfigPath == null) {
            throw new CassandraConnectorConfigException("Please specify SSL config path in cdc.yml");
        }
        Yaml yaml = new Yaml();
        try (FileInputStream fis = new FileInputStream(sslConfigPath);){
            SslConfig sslConfig = new SslConfig((Map)yaml.load((InputStream)fis));
            SslContext sslContext = SslContextFactory.createSslContext(sslConfig);
            return sslContext;
        }
    }

    public static SslContext createSslContext(SslConfig config) throws GeneralSecurityException, IOException {
        try {
            Throwable throwable;
            FileInputStream is;
            SslContextBuilder builder = SslContextBuilder.forClient();
            if (config.keyStoreLocation() != null) {
                KeyStore keyStore = KeyStore.getInstance(config.keyStoreType());
                try {
                    is = new FileInputStream(config.keyStoreLocation());
                    throwable = null;
                    try {
                        keyStore.load(is, config.keyStorePassword().toCharArray());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    LOGGER.error("failed to load the key store: location=" + config.keyStoreLocation() + " type=" + config.keyStoreType());
                    throw ex;
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(config.getKeyManagerAlgorithm());
                keyManagerFactory.init(keyStore, config.keyStorePassword().toCharArray());
                builder = SslContextBuilder.forClient();
                builder.keyManager(keyManagerFactory);
            } else {
                LOGGER.error("KeyStoreLocation was not specified. Building SslContext without certificate. This is not suitable for PRODUCTION");
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                builder = builder.keyManager(ssc.certificate(), ssc.privateKey());
            }
            if (config.trustStoreLocation() != null) {
                KeyStore trustStore = KeyStore.getInstance(config.trustStoreType());
                try {
                    is = new FileInputStream(config.trustStoreLocation());
                    throwable = null;
                    try {
                        trustStore.load(is, config.trustStorePassword().toCharArray());
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    LOGGER.error("failed to load the trust store: location=" + config.trustStoreLocation() + " type=" + config.trustStoreType());
                    throw ex;
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(config.trustManagerAlgorithm());
                trustManagerFactory.init(trustStore);
                builder.trustManager(trustManagerFactory);
            } else {
                LOGGER.error("TrustStoreLocation was not specified. Building SslContext using InsecureTrustManagerFactory. This is not suitable for PRODUCTION");
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            return builder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            LOGGER.error("Failed to create SslContext", (Throwable)e);
            throw e;
        }
    }
}

