/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.TableMetadata;
import io.debezium.connector.cassandra.CassandraClient;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorSchemaException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaHolder.class);
    private final Map<KeyspaceTable, KeyValueSchema> tableToKVSchemaMap = new ConcurrentHashMap<KeyspaceTable, KeyValueSchema>();
    private final CassandraClient cassandraClient;
    private final String connectorName;

    public SchemaHolder(CassandraClient cassandraClient, String connectorName) {
        this.cassandraClient = cassandraClient;
        this.connectorName = connectorName;
        this.refreshSchemas();
    }

    public void refreshSchemas() {
        LOGGER.debug("Refreshing schemas...");
        Map<KeyspaceTable, TableMetadata> latest = this.getLatestTableMetadatas();
        this.removeDeletedTableSchemas(latest);
        this.createOrUpdateNewTableSchemas(latest);
        LOGGER.debug("Schemas are refreshed");
    }

    public KeyValueSchema getOrUpdateKeyValueSchema(KeyspaceTable kt) {
        if (!this.tableToKVSchemaMap.containsKey(kt)) {
            this.refreshSchema(kt);
        }
        return this.tableToKVSchemaMap.getOrDefault(kt, null);
    }

    public Set<TableMetadata> getCdcEnabledTableMetadataSet() {
        return this.tableToKVSchemaMap.values().stream().map(KeyValueSchema::tableMetadata).filter(tm -> tm.getOptions().isCDC()).collect(Collectors.toSet());
    }

    public static Schema getFieldSchema(String fieldName, Schema schema) {
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            List unionOfSchemas = schema.getTypes();
            for (Schema innerSchema : unionOfSchemas) {
                if (!innerSchema.getName().equals(fieldName)) continue;
                return innerSchema;
            }
            throw new CassandraConnectorSchemaException("Union type does not contain field " + fieldName);
        }
        if (schema.getType().equals((Object)Schema.Type.RECORD)) {
            return schema.getField(fieldName).schema();
        }
        throw new CassandraConnectorSchemaException("Only UNION and RECORD types are supported for this method, but encountered " + schema.getType());
    }

    private void refreshSchema(KeyspaceTable keyspaceTable) {
        LOGGER.debug("Refreshing schema for {}", (Object)keyspaceTable);
        TableMetadata existing = this.tableToKVSchemaMap.containsKey(keyspaceTable) ? this.tableToKVSchemaMap.get(keyspaceTable).tableMetadata() : null;
        TableMetadata latest = this.cassandraClient.getCdcEnabledTableMetadata(keyspaceTable.keyspace, keyspaceTable.table);
        if (existing != latest) {
            if (existing == null) {
                this.tableToKVSchemaMap.put(keyspaceTable, new KeyValueSchema(this.connectorName, latest));
                LOGGER.debug("Updated schema for {}", (Object)keyspaceTable);
            }
            if (latest == null) {
                this.tableToKVSchemaMap.remove(keyspaceTable);
                LOGGER.debug("Removed schema for {}", (Object)keyspaceTable);
            }
        }
    }

    private Map<KeyspaceTable, TableMetadata> getLatestTableMetadatas() {
        HashMap<KeyspaceTable, TableMetadata> latest = new HashMap<KeyspaceTable, TableMetadata>();
        for (TableMetadata tm : this.cassandraClient.getCdcEnabledTableMetadataList()) {
            latest.put(new KeyspaceTable(tm), tm);
        }
        return latest;
    }

    private void removeDeletedTableSchemas(Map<KeyspaceTable, TableMetadata> latestTableMetadataMap) {
        Set<KeyspaceTable> existingTables = this.tableToKVSchemaMap.keySet();
        Set<KeyspaceTable> latestTables = latestTableMetadataMap.keySet();
        existingTables.removeAll(latestTables);
        this.tableToKVSchemaMap.keySet().removeAll(existingTables);
    }

    private void createOrUpdateNewTableSchemas(Map<KeyspaceTable, TableMetadata> latestTableMetadataMap) {
        latestTableMetadataMap.forEach((table, metadata) -> {
            TableMetadata existingTableMetadata;
            TableMetadata tableMetadata = existingTableMetadata = this.tableToKVSchemaMap.containsKey(table) ? this.tableToKVSchemaMap.get(table).tableMetadata() : null;
            if (existingTableMetadata != metadata) {
                KeyValueSchema keyValueSchema = new KeyValueSchema(this.connectorName, (TableMetadata)metadata);
                this.tableToKVSchemaMap.put((KeyspaceTable)table, keyValueSchema);
                LOGGER.debug("Updated schema for {}", table);
            }
        });
    }

    public static class KeyValueSchema {
        private final TableMetadata tableMetadata;
        private final Schema keySchema;
        private final Schema valueSchema;

        KeyValueSchema(String connectorName, TableMetadata tableMetadata) {
            this.tableMetadata = tableMetadata;
            this.keySchema = Record.keySchema(connectorName, tableMetadata);
            this.valueSchema = Record.valueSchema(connectorName, tableMetadata);
        }

        public TableMetadata tableMetadata() {
            return this.tableMetadata;
        }

        public Schema keySchema() {
            return this.keySchema;
        }

        public Schema valueSchema() {
            return this.valueSchema;
        }
    }
}

