/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.TableMetadata;
import io.debezium.connector.cassandra.AvroRecord;
import io.debezium.connector.cassandra.CellData;
import io.debezium.connector.cassandra.SchemaHolder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;

public class RowData
implements AvroRecord {
    private final Map<String, CellData> cellMap = new LinkedHashMap<String, CellData>();

    public void addCell(CellData cellData) {
        this.cellMap.put(cellData.name, cellData);
    }

    public void removeCell(String columnName) {
        if (this.hasCell(columnName)) {
            this.cellMap.remove(columnName);
        }
    }

    public boolean hasCell(String columnName) {
        return this.cellMap.containsKey(columnName);
    }

    @Override
    public GenericRecord record(Schema schema) {
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        for (Schema.Field field : schema.getFields()) {
            Schema unionSchema = SchemaHolder.getFieldSchema(field.name(), schema);
            Schema cellSchema = SchemaHolder.getFieldSchema(field.name(), unionSchema);
            CellData cellData = this.cellMap.get(field.name());
            if (cellData == null) continue;
            builder.set(field.name(), (Object)cellData.record(cellSchema));
        }
        return builder.build();
    }

    public RowData copy() {
        RowData copy = new RowData();
        for (CellData cellData : this.cellMap.values()) {
            copy.addCell(cellData);
        }
        return copy;
    }

    static Schema rowSchema(TableMetadata tm) {
        SchemaBuilder.FieldAssembler assembler = SchemaBuilder.builder().record("after").fields();
        for (ColumnMetadata cm : tm.getColumns()) {
            Schema nullableCellSchema = RowData.nullableCellSchema(cm);
            if (nullableCellSchema == null) continue;
            assembler.name(cm.getName()).type(nullableCellSchema).withDefault(null);
        }
        return (Schema)assembler.endRecord();
    }

    private static Schema nullableCellSchema(ColumnMetadata cm) {
        Schema cellSchema = CellData.cellSchema(cm);
        if (cellSchema != null) {
            return (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.builder().unionOf().nullType()).and().type(cellSchema)).endUnion();
        }
        return null;
    }

    List<CellData> getPrimary() {
        return this.cellMap.values().stream().filter(CellData::isPrimary).collect(Collectors.toList());
    }

    public String toString() {
        return this.cellMap.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowData rowData = (RowData)o;
        return Objects.equals(this.cellMap, rowData.cellMap);
    }

    public int hashCode() {
        return Objects.hash(this.cellMap);
    }
}

