/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.TableMetadata;
import io.debezium.connector.cassandra.CellData;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.cassandra.SourceInfo;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.CassandraTypeToAvroSchemaMapper;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.cassandra.db.marshal.AbstractType;

public abstract class Record
implements Event {
    static final String NAMESPACE = "io.debezium.connector.cassandra";
    static final String AFTER = "after";
    static final String OPERATION = "op";
    static final String SOURCE = "source";
    static final String TIMESTAMP = "ts_ms";
    private final SourceInfo source;
    private final RowData rowData;
    private final Operation op;
    private final long ts;
    private final Schema keySchema;
    private final Schema valueSchema;
    private final boolean shouldMarkOffset;

    Record(SourceInfo source, RowData rowData, Schema keySchema, Schema valueSchema, Operation op, boolean shouldMarkOffset, long ts) {
        this.source = source;
        this.rowData = rowData;
        this.op = op;
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.shouldMarkOffset = shouldMarkOffset;
        this.ts = ts;
    }

    public GenericRecord buildKey() {
        if (this.keySchema == null) {
            return null;
        }
        List<CellData> primary = this.rowData.getPrimary();
        GenericRecordBuilder builder = new GenericRecordBuilder(this.keySchema);
        for (CellData cellData : primary) {
            builder.set(cellData.name, cellData.value);
        }
        return builder.build();
    }

    public GenericRecord buildValue() {
        if (this.valueSchema == null) {
            return null;
        }
        return new GenericRecordBuilder(this.valueSchema).set(TIMESTAMP, (Object)this.ts).set(OPERATION, (Object)this.op.getValue()).set(SOURCE, (Object)this.source.record(SchemaHolder.getFieldSchema(SOURCE, this.valueSchema))).set(AFTER, (Object)this.rowData.record(SchemaHolder.getFieldSchema(AFTER, this.valueSchema))).build();
    }

    public static Schema keySchema(String connectorName, TableMetadata tm) {
        if (tm == null) {
            return null;
        }
        SchemaBuilder.FieldAssembler assembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.builder().record(Record.getKeyName(connectorName, tm)).namespace(NAMESPACE)).fields();
        for (ColumnMetadata cm : tm.getPrimaryKey()) {
            AbstractType<?> convertedType = CassandraTypeConverter.convert(cm.getType());
            Schema colSchema = CassandraTypeToAvroSchemaMapper.getSchema(convertedType, false);
            if (colSchema == null) continue;
            assembler.name(cm.getName()).type(colSchema).noDefault();
        }
        return (Schema)assembler.endRecord();
    }

    public static Schema valueSchema(String connectorName, TableMetadata tm) {
        if (tm == null) {
            return null;
        }
        return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.builder().record(Record.getValueName(connectorName, tm)).namespace(NAMESPACE)).fields().name(TIMESTAMP).type().longType().noDefault().name(OPERATION).type().stringType().noDefault().name(SOURCE).type(SourceInfo.SOURCE_SCHEMA).noDefault().name(AFTER).type(RowData.rowSchema(tm)).noDefault().endRecord();
    }

    public String toString() {
        return "Record{source=" + this.source + ", after=" + this.rowData + ", keySchema=" + this.keySchema + ", valueSchema=" + this.valueSchema + ", op=" + (Object)((Object)this.op) + ", ts=" + this.ts + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Record record = (Record)o;
        return this.ts == record.ts && Objects.equals(this.source, record.source) && Objects.equals(this.rowData, record.rowData) && Objects.equals(this.keySchema, record.keySchema) && Objects.equals(this.valueSchema, record.valueSchema) && this.op == record.op;
    }

    public static String getKeyName(String connectorName, TableMetadata tm) {
        return connectorName + "." + tm.getKeyspace().getName() + "." + tm.getName() + ".Key";
    }

    public static String getValueName(String connectorName, TableMetadata tm) {
        return connectorName + "." + tm.getKeyspace().getName() + "." + tm.getName() + ".Value";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.rowData, this.keySchema, this.valueSchema, this.op, this.ts});
    }

    public SourceInfo getSource() {
        return this.source;
    }

    public RowData getRowData() {
        return this.rowData;
    }

    public Operation getOp() {
        return this.op;
    }

    public long getTs() {
        return this.ts;
    }

    public Schema getKeySchema() {
        return this.keySchema;
    }

    public Schema getValueSchema() {
        return this.valueSchema;
    }

    public boolean shouldMarkOffset() {
        return this.shouldMarkOffset;
    }

    public static enum Operation {
        INSERT("i"),
        UPDATE("u"),
        DELETE("d");

        private String value;

        private Operation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

