/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.CassandraTopicSelector;
import io.debezium.connector.cassandra.OffsetFlushPolicy;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.SourceInfo;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRecordEmitter
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaRecordEmitter.class);
    private final KafkaProducer<GenericRecord, GenericRecord> producer;
    private final CassandraTopicSelector topicSelector;
    private final OffsetWriter offsetWriter;
    private final OffsetFlushPolicy offsetFlushPolicy;
    private final Map<Record, Future<RecordMetadata>> futures = new LinkedHashMap<Record, Future<RecordMetadata>>();
    private final Object lock = new Object();
    private long timeOfLastFlush;
    private long emitCount = 0L;

    public KafkaRecordEmitter(String kafkaTopicPrefix, Properties kafkaProperties, OffsetWriter offsetWriter, Duration offsetFlushIntervalMs, long maxOffsetFlushSize) {
        this.producer = new KafkaProducer(kafkaProperties);
        this.topicSelector = CassandraTopicSelector.defaultSelector(kafkaTopicPrefix);
        this.offsetWriter = offsetWriter;
        this.offsetFlushPolicy = offsetFlushIntervalMs.isZero() ? OffsetFlushPolicy.always() : OffsetFlushPolicy.periodic(offsetFlushIntervalMs, maxOffsetFlushSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(Record record) {
        Object object = this.lock;
        synchronized (object) {
            ProducerRecord<GenericRecord, GenericRecord> producerRecord = this.toProducerRecord(record);
            Future future = this.producer.send(producerRecord);
            this.futures.put(record, future);
            this.maybeFlushAndMarkOffset();
        }
    }

    private ProducerRecord<GenericRecord, GenericRecord> toProducerRecord(Record record) {
        String topic = this.topicSelector.topicNameFor(record.getSource().keyspaceTable);
        return new ProducerRecord(topic, (Object)record.buildKey(), (Object)record.buildValue());
    }

    private void maybeFlushAndMarkOffset() {
        long now = System.currentTimeMillis();
        long timeSinceLastFlush = now - this.timeOfLastFlush;
        if (this.offsetFlushPolicy.shouldFlush(Duration.ofMillis(timeSinceLastFlush), this.futures.size())) {
            this.flushAndMarkOffset();
            this.timeOfLastFlush = now;
        }
    }

    private void flushAndMarkOffset() {
        this.futures.entrySet().stream().filter(this::flush).filter(this::hasOffset).forEach(this::markOffset);
        this.offsetWriter.flush();
        this.futures.clear();
    }

    private boolean flush(Map.Entry<Record, Future<RecordMetadata>> recordEntry) {
        try {
            recordEntry.getValue().get();
            if (++this.emitCount % 10000L == 0L) {
                LOGGER.info("Emitted {} records to Kafka Broker", (Object)this.emitCount);
                this.emitCount = 0L;
            }
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Failed to emit record {}", (Object)recordEntry.getKey(), (Object)e);
            return false;
        }
    }

    private boolean hasOffset(Map.Entry<Record, Future<RecordMetadata>> recordEntry) {
        return recordEntry.getKey().shouldMarkOffset();
    }

    private void markOffset(Map.Entry<Record, Future<RecordMetadata>> recordEntry) {
        SourceInfo source = recordEntry.getKey().getSource();
        String sourceTable = source.keyspaceTable.name();
        String sourceOffset = source.offsetPosition.serialize();
        boolean isSnapshot = source.snapshot;
        this.offsetWriter.markOffset(sourceTable, sourceOffset, isSnapshot);
        if (isSnapshot) {
            LOGGER.info("Mark snapshot offset for table '{}'", (Object)sourceTable);
        }
    }

    @Override
    public void close() {
        this.producer.close();
    }
}

