/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.connector.cassandra.CassandraClient;
import io.debezium.connector.cassandra.CassandraConnectorTask;
import java.util.HashMap;

public class CassandraConnectorTaskHealthCheck
extends HealthCheck {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final CassandraConnectorTask.ProcessorGroup processorGroup;
    private final CassandraClient cassandraClient;

    public CassandraConnectorTaskHealthCheck(CassandraConnectorTask.ProcessorGroup processorGroup, CassandraClient cassandraClient) {
        this.processorGroup = processorGroup;
        this.cassandraClient = cassandraClient;
    }

    protected HealthCheck.Result check() throws Exception {
        if (this.isHealthy()) {
            return HealthCheck.Result.healthy((String)this.getMessage());
        }
        return HealthCheck.Result.unhealthy((String)this.getMessage());
    }

    private boolean isHealthy() {
        if (!this.processorGroup.isRunning()) {
            return false;
        }
        return this.cassandraClient.isQueryable();
    }

    private String getMessage() throws JsonProcessingException {
        HashMap<String, Boolean> health = new HashMap<String, Boolean>();
        health.put(this.processorGroup.getName(), this.processorGroup.isRunning());
        health.put(this.cassandraClient.getClass().getName(), this.cassandraClient.isQueryable());
        return mapper.writeValueAsString(health);
    }
}

