/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.config.Configuration;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CommitLogPostProcessor;
import io.debezium.connector.cassandra.CommitLogTransfer;
import io.debezium.connector.cassandra.TestUtils;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CommitLogPostProcessorTest {
    @Test
    public void testPostProcessor() throws Exception {
        int expectedArchivedFile = 10;
        int expectedErrorFile = 10;
        final AtomicInteger archivedFileCount = new AtomicInteger(0);
        final AtomicInteger errorFileCount = new AtomicInteger(0);
        CommitLogTransfer myTransfer = new CommitLogTransfer(){

            public void onSuccessTransfer(File file) {
                archivedFileCount.incrementAndGet();
            }

            public void onErrorTransfer(File file) {
                errorFileCount.incrementAndGet();
            }

            public void getErrorCommitLogFiles() {
            }
        };
        CassandraConnectorConfig config = (CassandraConnectorConfig)Mockito.spy((Object)new CassandraConnectorConfig(Configuration.from((Properties)TestUtils.generateDefaultConfigMap())));
        Mockito.when((Object)config.getCommitLogTransfer()).thenReturn((Object)myTransfer);
        CommitLogPostProcessor postProcessor = (CommitLogPostProcessor)Mockito.spy((Object)new CommitLogPostProcessor(config));
        Mockito.when((Object)postProcessor.isRunning()).thenReturn((Object)true);
        File dir = new File(config.commitLogRelocationDir());
        TestUtils.populateFakeCommitLogsForDirectory(expectedArchivedFile, new File(dir, "archive"));
        TestUtils.populateFakeCommitLogsForDirectory(expectedErrorFile, new File(dir, "error"));
        postProcessor.process();
        postProcessor.shutDown(true);
        Assert.assertEquals((long)expectedArchivedFile, (long)archivedFileCount.get());
        Assert.assertEquals((long)expectedErrorFile, (long)errorFileCount.get());
        TestUtils.clearCommitLogFromDirectory(dir, true);
    }
}

