/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.google.common.collect.ImmutableMap;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CommitLogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;

public class TestUtils {
    public static final String TEST_CONNECTOR_NAME = "cassandra-01";
    public static final String TEST_CASSANDRA_YAML_CONFIG = "cassandra-unit.yaml";
    public static final String TEST_CASSANDRA_HOSTS = "127.0.0.1";
    public static final int TEST_CASSANDRA_PORT = 9042;
    public static final String TEST_KAFKA_SERVERS = "localhost:9092";
    public static final String TEST_SCHEMA_REGISTRY_URL = "http://localhost:8081";
    public static final String TEST_KAFKA_TOPIC_PREFIX = "test_topic";
    public static final String TEST_KEYSPACE_NAME = "test_keyspace";
    public static final String TEST_KEYSPACE_NAME_2 = "test_keyspace2";
    public static String TEST_TABLE_NAME = "table_" + UUID.randomUUID().toString().replace("-", "");
    public static String TEST_TABLE_NAME_2 = "table2_" + UUID.randomUUID().toString().replace("-", "");

    public static Properties generateDefaultConfigMap() throws IOException {
        Properties props = new Properties();
        props.put(CassandraConnectorConfig.TOPIC_PREFIX.name(), TEST_CONNECTOR_NAME);
        props.put(CassandraConnectorConfig.CASSANDRA_CONFIG.name(), Paths.get("src/test/resources/cassandra-unit-for-context.yaml", new String[0]).toAbsolutePath().toString());
        props.put(CassandraConnectorConfig.TOPIC_PREFIX.name(), TEST_KAFKA_TOPIC_PREFIX);
        props.put(CassandraConnectorConfig.OFFSET_BACKING_STORE_DIR.name(), Files.createTempDirectory("offset", new FileAttribute[0]).toString());
        props.put("kafka.producer.bootstrap.servers", TEST_KAFKA_SERVERS);
        props.put(CassandraConnectorConfig.COMMIT_LOG_RELOCATION_DIR.name(), Files.createTempDirectory("cdc_raw_relocation", new FileAttribute[0]).toString());
        props.put(CassandraConnectorConfig.KEY_CONVERTER_CLASS_CONFIG.name(), "org.apache.kafka.connect.json.JsonConverter");
        props.put(CassandraConnectorConfig.VALUE_CONVERTER_CLASS_CONFIG.name(), "org.apache.kafka.connect.json.JsonConverter");
        props.put(CassandraConnectorConfig.CASSANDRA_DRIVER_CONFIG_FILE.name(), Paths.get("src/test/resources/application.conf", new String[0]).toAbsolutePath().toString());
        return props;
    }

    public static HashMap<String, Object> propertiesForContext() throws IOException {
        return new HashMap<String, Object>(){
            {
                this.put(CassandraConnectorConfig.TOPIC_PREFIX.name(), TestUtils.TEST_CONNECTOR_NAME);
                this.put(CassandraConnectorConfig.CASSANDRA_CONFIG.name(), Paths.get("src/test/resources/cassandra-unit-for-context.yaml", new String[0]).toAbsolutePath().toString());
                this.put(CassandraConnectorConfig.TOPIC_PREFIX.name(), TestUtils.TEST_KAFKA_TOPIC_PREFIX);
                this.put(CassandraConnectorConfig.OFFSET_BACKING_STORE_DIR.name(), Files.createTempDirectory("offset", new FileAttribute[0]).toString());
                this.put("kafka.producer.bootstrap.servers", TestUtils.TEST_KAFKA_SERVERS);
                this.put(CassandraConnectorConfig.COMMIT_LOG_RELOCATION_DIR.name(), Files.createTempDirectory("cdc_raw_relocation", new FileAttribute[0]).toString());
                this.put(CassandraConnectorConfig.KEY_CONVERTER_CLASS_CONFIG.name(), "org.apache.kafka.connect.json.JsonConverter");
                this.put(CassandraConnectorConfig.VALUE_CONVERTER_CLASS_CONFIG.name(), "org.apache.kafka.connect.json.JsonConverter");
                this.put(CassandraConnectorConfig.CASSANDRA_DRIVER_CONFIG_FILE.name(), Paths.get("src/test/resources/application.conf", new String[0]).toAbsolutePath().toString());
            }
        };
    }

    public static void createTestKeyspace() throws Exception {
        TestUtils.createTestKeyspace(TEST_KEYSPACE_NAME);
    }

    public static void createTestKeyspace(String keyspace) throws Exception {
        try (CqlSession session = (CqlSession)CqlSession.builder().build();){
            session.execute((Statement)((CreateKeyspace)SchemaBuilder.createKeyspace((String)keyspace).ifNotExists().withNetworkTopologyStrategy((Map)ImmutableMap.of((Object)"datacenter1", (Object)1))).build());
        }
    }

    public static List<String> getTables(String keyspace, CqlSession session) {
        return ((KeyspaceMetadata)session.getMetadata().getKeyspace(keyspace).get()).getTables().values().stream().map(tmd -> tmd.getName().toString()).collect(Collectors.toList());
    }

    public static void truncateTestKeyspaceTableData() {
        TestUtils.truncateTestKeyspaceTableData(TEST_KEYSPACE_NAME);
    }

    public static void truncateTestKeyspaceTableData(String keyspace) {
        try (CqlSession session = (CqlSession)CqlSession.builder().build();){
            for (String table : TestUtils.getTables(keyspace, session)) {
                session.execute((Statement)SimpleStatement.newInstance((String)String.format("TRUNCATE %s.%s", keyspace, table)));
            }
        }
    }

    public static void deleteTestKeyspaceTables() throws Exception {
        TestUtils.deleteTestKeyspaceTables(TEST_KEYSPACE_NAME);
    }

    public static void deleteTestKeyspaceTables(String keyspaceName) throws Exception {
        try (CqlSession session = (CqlSession)CqlSession.builder().build();){
            for (String table : TestUtils.getTables(keyspaceName, session)) {
                session.execute((Statement)SimpleStatement.newInstance((String)String.format("DROP TABLE IF EXISTS %s.%s", keyspaceName, table)));
            }
        }
    }

    public static void runCql(String statement) {
        TestUtils.runCql(SimpleStatement.builder((String)statement).build());
    }

    public static void runCql(Statement<?> statement) {
        try (CqlSession session = (CqlSession)CqlSession.builder().build();){
            session.execute(statement);
        }
    }

    public static void deleteTestOffsets(CassandraConnectorContext context) throws IOException {
        File[] files;
        String offsetDirPath = context.getCassandraConnectorConfig().offsetBackingStoreDir();
        File offsetDir = new File(offsetDirPath);
        if (offsetDir.isDirectory() && (files = offsetDir.listFiles()) != null) {
            for (File f : files) {
                Files.delete(f.toPath());
            }
        }
    }

    public static String keyspaceTable(String tableName) {
        return "test_keyspace." + tableName;
    }

    public static void populateFakeCommitLogsForDirectory(int numOfFiles, File directory) throws IOException {
        if (directory.exists() && !directory.isDirectory()) {
            throw new IOException(directory + " is not a directory");
        }
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Cannot create directory " + directory);
        }
        TestUtils.clearCommitLogFromDirectory(directory, true);
        long prefix = System.currentTimeMillis();
        for (int i = 0; i < numOfFiles; ++i) {
            long ts = prefix + (long)i;
            Path path = Paths.get(directory.getAbsolutePath(), "CommitLog-6-" + ts + ".log");
            boolean success = path.toFile().createNewFile();
            if (success) continue;
            throw new IOException("Failed to create new commit log for testing");
        }
    }

    public static void clearCommitLogFromDirectory(File directory, boolean recursive) throws IOException {
        File[] directories;
        File[] commitLogs;
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException(directory + " is not a valid directory");
        }
        for (File commitLog : commitLogs = CommitLogUtil.getCommitLogs((File)directory)) {
            CommitLogUtil.deleteCommitLog((File)commitLog);
        }
        if (recursive && (directories = directory.listFiles(File::isDirectory)) != null) {
            for (File dir : directories) {
                TestUtils.clearCommitLogFromDirectory(dir, true);
            }
        }
    }
}

