/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import io.debezium.connector.cassandra.CassandraConnectorTaskTemplate;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CassandraClient
implements AutoCloseable {
    private final CqlSession session;

    public CassandraClient(String config, SchemaChangeListener schemaChangeListener) {
        this.session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(DriverConfigLoader.fromFile((File)new File(config)))).withSchemaChangeListener(schemaChangeListener)).build();
        this.registerClusterMetrics(this.session.getMetadata().getClusterName().orElse("unknown-cluster-name"));
    }

    public Set<Node> getHosts() {
        return new HashSet<Node>(this.session.getMetadata().getNodes().values());
    }

    public String getClusterName() {
        return this.session.getMetadata().getClusterName().orElse("unknown-cluster-name");
    }

    public boolean isQueryable() {
        return !this.session.isClosed();
    }

    public ResultSet execute(SimpleStatement statement) {
        return this.session.execute((Statement)statement);
    }

    public ResultSet execute(String query) {
        return this.session.execute(query);
    }

    public ResultSet execute(String query, Object ... values) {
        return this.session.execute(query, values);
    }

    public ResultSet execute(String query, Map<String, Object> values) {
        return this.session.execute(query, values);
    }

    public void shutdown() {
        if (!this.session.isClosed()) {
            this.session.close();
        }
    }

    private void registerClusterMetrics(String prefix) {
        Optional metrics = this.session.getMetrics();
        if (metrics.isPresent()) {
            MetricRegistry clusterRegistry = ((Metrics)metrics.get()).getRegistry();
            clusterRegistry.getMetrics().forEach((key, value) -> CassandraConnectorTaskTemplate.METRIC_REGISTRY_INSTANCE.register(MetricRegistry.name((String)prefix, (String[])new String[]{key}), value));
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

