/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import io.debezium.config.Configuration;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.TestUtils;
import io.debezium.util.Testing;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.awaitility.Awaitility;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;

public abstract class CassandraConnectorTestBase {
    public static final String CASSANDRA_SERVER_DIR = "/var/lib/cassandra";
    private static final String cassandraDir = CassandraConnectorTestBase.createCassandraDir();
    private static final String dockerDir = System.getProperty("docker.dir", "docker");
    private static final Consumer<CreateContainerCmd> cmd = e -> e.getHostConfig().withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)9042), new ExposedPort(9042))});
    @ClassRule
    public static GenericContainer cassandra = new GenericContainer((Future)new ImageFromDockerfile().withFileFromPath(".", new File(dockerDir).toPath())).withExposedPorts(new Integer[]{9042}).withStartupTimeout(Duration.ofMinutes(3L)).withCreateContainerCmdModifier(cmd).withFileSystemBind(cassandraDir, "/var/lib/cassandra", BindMode.READ_WRITE).withCommand("-Dcassandra.ring_delay_ms=5000 -Dcassandra.superuser_setup_delay_ms=1000");

    @BeforeClass
    public static void setUpClass() throws Exception {
        CassandraConnectorTestBase.waitForCql();
        TestUtils.createTestKeyspace();
    }

    @AfterClass
    public static void tearDownClass() {
        cassandra.stop();
    }

    public static void destroyTestKeyspace() throws Exception {
        TestUtils.deleteTestKeyspaceTables("test_keyspace");
    }

    public static void destroyTestKeyspace(String keyspace) {
        try (CqlSession session = (CqlSession)CqlSession.builder().build();){
            session.execute((Statement)SchemaBuilder.dropKeyspace((String)keyspace).ifExists().build());
        }
    }

    protected abstract CassandraConnectorContext generateTaskContext(Configuration var1) throws Exception;

    protected CassandraConnectorContext generateTaskContext() throws Exception {
        return this.generateTaskContext(Configuration.from((Properties)TestUtils.generateDefaultConfigMap()));
    }

    protected CassandraConnectorContext generateTaskContext(Map<String, Object> configs) throws Exception {
        return this.generateTaskContext(Configuration.from(configs));
    }

    protected static void waitForCql() {
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).pollInSameThread().timeout(1L, TimeUnit.MINUTES).until(() -> {
            Boolean bl;
            block8: {
                CqlSession ignored = (CqlSession)CqlSession.builder().build();
                try {
                    bl = true;
                    if (ignored == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                ignored.close();
            }
            return bl;
        });
    }

    protected static String createCassandraDir(String path) {
        try {
            File cassandraDir = Testing.Files.createTestingDirectory((String)path, (boolean)true);
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxrwxrwx");
                Files.setPosixFilePermissions(cassandraDir.toPath(), permissions);
            }
            return cassandraDir.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String createCassandraDir() {
        String cassandraDir = CassandraConnectorTestBase.createCassandraDir("cassandra");
        CassandraConnectorTestBase.createCassandraDir("cassandra/hints");
        CassandraConnectorTestBase.createCassandraDir("cassandra/data");
        CassandraConnectorTestBase.createCassandraDir("cassandra/metadata");
        CassandraConnectorTestBase.createCassandraDir("cassandra/commitlog");
        CassandraConnectorTestBase.createCassandraDir("cassandra/cdc_raw");
        CassandraConnectorTestBase.createCassandraDir("cassandra/saved_caches");
        return cassandraDir;
    }
}

