/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.AbstractDirectoryWatcher;
import io.debezium.connector.cassandra.AbstractProcessor;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CommitLogIdxParser;
import io.debezium.connector.cassandra.CommitLogProcessingResult;
import io.debezium.connector.cassandra.CommitLogProcessorMetrics;
import io.debezium.connector.cassandra.CommitLogSegmentReader;
import io.debezium.connector.cassandra.CommitLogTransfer;
import io.debezium.connector.cassandra.CommitLogUtil;
import io.debezium.connector.cassandra.LogicalCommitLog;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogIdxProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogIdxProcessor.class);
    private static final String NAME = "Commit Log Processor";
    private final CassandraConnectorContext context;
    private final File cdcDir;
    private AbstractDirectoryWatcher watcher;
    private final CommitLogProcessorMetrics metrics;
    private boolean initial = true;
    private final boolean errorCommitLogReprocessEnabled;
    private final CommitLogTransfer commitLogTransfer;
    private final ExecutorService executorService;
    static final Set<Pair<CommitLogIdxParser, Future<CommitLogProcessingResult>>> submittedProcessings = ConcurrentHashMap.newKeySet();
    private final CommitLogSegmentReader commitLogReader;

    public CommitLogIdxProcessor(CassandraConnectorContext context, CommitLogProcessorMetrics metrics, CommitLogSegmentReader commitLogReader, File cdcDir) {
        super(NAME, Duration.ZERO);
        this.context = context;
        this.commitLogTransfer = this.context.getCassandraConnectorConfig().getCommitLogTransfer();
        this.errorCommitLogReprocessEnabled = this.context.getCassandraConnectorConfig().errorCommitLogReprocessEnabled();
        this.cdcDir = cdcDir;
        this.executorService = Executors.newSingleThreadExecutor();
        this.metrics = metrics;
        this.commitLogReader = commitLogReader;
    }

    @Override
    public void initialize() {
        this.metrics.registerMetrics();
    }

    @Override
    public void destroy() {
        this.metrics.unregisterMetrics();
    }

    @Override
    public void stop() {
        try {
            this.executorService.shutdown();
            for (Pair<CommitLogIdxParser, Future<CommitLogProcessingResult>> submittedProcessing : submittedProcessings) {
                try {
                    ((CommitLogIdxParser)submittedProcessing.getFirst()).complete();
                    ((Future)submittedProcessing.getSecond()).get();
                }
                catch (Exception ex) {
                    LOGGER.warn("Waiting for submitted task to finish has failed.");
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to close executor service in CommitLogProcessor in a timely manner");
        }
        super.stop();
    }

    protected static synchronized void removeProcessing(CommitLogIdxParser parser) {
        submittedProcessings.stream().filter(p -> p.getFirst() == parser).findFirst().map(submittedProcessings::remove);
    }

    public void submit(Path index) {
        CommitLogIdxParser parser = new CommitLogIdxParser(new LogicalCommitLog(index.toFile()), this.metrics, this.context, this.commitLogReader);
        Future<CommitLogProcessingResult> future = this.executorService.submit(parser::process);
        submittedProcessings.add((Pair<CommitLogIdxParser, Future<CommitLogProcessingResult>>)new Pair((Object)parser, future));
        LOGGER.debug("Processing {} callables.", (Object)submittedProcessings.size());
    }

    @Override
    public boolean isRunning() {
        return super.isRunning() && !this.executorService.isShutdown() && !this.executorService.isTerminated();
    }

    @Override
    public void process() throws IOException, InterruptedException {
        if (this.watcher == null) {
            this.watcher = new AbstractDirectoryWatcher(this.cdcDir.toPath(), this.context.getCassandraConnectorConfig().cdcDirPollInterval(), Collections.singleton(StandardWatchEventKinds.ENTRY_CREATE)){

                @Override
                void handleEvent(WatchEvent<?> event, Path path) {
                    if (CommitLogIdxProcessor.this.isRunning() && path.getFileName().toString().endsWith("_cdc.idx")) {
                        CommitLogIdxProcessor.this.submit(path);
                    }
                }
            };
        }
        if (this.initial) {
            LOGGER.info("Reading existing commit logs in {}", (Object)this.cdcDir);
            File[] indexes = CommitLogUtil.getIndexes(this.cdcDir);
            Arrays.sort(indexes, CommitLogUtil::compareCommitLogsIndexes);
            for (File index : indexes) {
                if (!this.isRunning()) continue;
                this.submit(index.toPath());
            }
            if (this.errorCommitLogReprocessEnabled) {
                LOGGER.info("CommitLog Error Processing is enabled. Attempting to get all error commitLog files for re-processing.");
                this.commitLogTransfer.getErrorCommitLogFiles();
            }
            this.initial = false;
        }
        this.watcher.poll();
    }
}

