/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.transforms.EnvelopeTransformation;
import io.debezium.data.Envelope;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;
import org.junit.Test;

public class EnvelopeTransformationTest {
    @Test
    public void transformOperationInsert() {
        this.testTransformOperation(Record.Operation.INSERT, Envelope.Operation.CREATE);
    }

    @Test
    public void transformOperationUpdate() {
        this.testTransformOperation(Record.Operation.UPDATE, Envelope.Operation.UPDATE);
    }

    @Test
    public void transformOperationDelete() {
        this.testTransformOperation(Record.Operation.DELETE, Envelope.Operation.DELETE);
    }

    @Test
    public void transformOperationRangeTombostone() {
        this.testTransformOperation(Record.Operation.RANGE_TOMBSTONE, Envelope.Operation.TRUNCATE);
    }

    private void testTransformOperation(Record.Operation from, Envelope.Operation to) {
        SourceRecord sourceRecord = this.generateSourceRecord(from);
        Assert.assertEquals((Object)((Struct)sourceRecord.value()).get("op"), (Object)from.getValue());
        EnvelopeTransformation transform = new EnvelopeTransformation();
        transform.configure(Collections.emptyMap());
        SourceRecord transformedRecord = (SourceRecord)transform.apply((ConnectRecord)sourceRecord);
        Assert.assertEquals((Object)((Struct)transformedRecord.value()).get("op"), (Object)to.code());
        transform.close();
    }

    private SourceRecord generateSourceRecord(Record.Operation op) {
        Schema recordSchema = SchemaBuilder.struct().field("op", (Schema)SchemaBuilder.string()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(SchemaBuilder.struct().build()).build();
        Struct payload = new Struct(recordSchema);
        payload.put("op", (Object)op.getValue());
        SourceRecord sourceRecord = new SourceRecord(new HashMap(), new HashMap(), "test_topic", SchemaBuilder.STRING_SCHEMA, (Object)"key", envelope.schema(), (Object)payload);
        return sourceRecord;
    }
}

