/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import com.datastax.oss.driver.api.core.type.DataType;
import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.DecimalTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.VarIntTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.data.SchemaBuilder;

@ThreadSafe
@Immutable
public final class CassandraTypeDeserializer {
    private Map<Class<?>, TypeDeserializer> TYPE_MAP;
    private Map<Integer, TypeDeserializer> DATATYPE_MAP;
    private Function<Object, Object> baseType;

    private CassandraTypeDeserializer() {
    }

    public static CassandraTypeDeserializer getInstance() {
        return CassandraTypeDeserializerInstanceHolder.instance;
    }

    public static void init(List<AbstractTypeDeserializer> typeDeserializers, DecimalMode decimalMode, VarIntMode varIntMode, Function<Object, Object> baseType) {
        CassandraTypeDeserializer instance = CassandraTypeDeserializer.getInstance();
        instance.initInternal(typeDeserializers, decimalMode, varIntMode, baseType);
    }

    private void initInternal(List<AbstractTypeDeserializer> typeDeserializers, DecimalMode decimalMode, VarIntMode varIntMode, Function<Object, Object> baseType) {
        if (this.TYPE_MAP != null) {
            return;
        }
        HashMap tmp = new HashMap();
        HashMap tmpDatatypeMap = new HashMap();
        typeDeserializers.forEach(typeDeserializer -> {
            tmp.put(typeDeserializer.getAbstractTypeClass(), typeDeserializer);
            tmpDatatypeMap.put(typeDeserializer.getDataType(), typeDeserializer);
        });
        this.TYPE_MAP = Collections.unmodifiableMap(tmp);
        this.DATATYPE_MAP = Collections.unmodifiableMap(tmpDatatypeMap);
        this.baseType = baseType;
        CassandraTypeDeserializer.setDecimalMode(decimalMode);
        CassandraTypeDeserializer.setVarIntMode(varIntMode);
    }

    private Object baseType(Object abstractType) {
        return this.baseType.apply(abstractType);
    }

    public static Object deserialize(DataType dataType, ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        TypeDeserializer typeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(dataType);
        return typeDeserializer.deserialize(typeDeserializer.getAbstractType(dataType), bb);
    }

    public static Object deserialize(Object abstractType, ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        abstractType = CassandraTypeDeserializer.getInstance().baseType(abstractType);
        TypeDeserializer typeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(abstractType);
        return typeDeserializer.deserialize(abstractType, bb);
    }

    public static Object deserialize(Object collectionType, List<ByteBuffer> bbList) {
        TypeDeserializer typeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(collectionType);
        return ((CollectionTypeDeserializer)typeDeserializer).deserialize(collectionType, bbList);
    }

    public static SchemaBuilder getSchemaBuilder(Object abstractType) {
        TypeDeserializer typeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(abstractType);
        return typeDeserializer.getSchemaBuilder(abstractType);
    }

    public static SchemaBuilder getSchemaBuilder(DataType dataType) {
        TypeDeserializer typeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(dataType);
        return typeDeserializer.getSchemaBuilder(typeDeserializer.getAbstractType(dataType));
    }

    public static TypeDeserializer getTypeDeserializer(Object abstractType) {
        return CassandraTypeDeserializer.getInstance().TYPE_MAP.get(abstractType.getClass());
    }

    public static TypeDeserializer getTypeDeserializer(DataType dataType) {
        return CassandraTypeDeserializer.getInstance().DATATYPE_MAP.get(dataType.getProtocolCode());
    }

    public static void setDecimalMode(DecimalMode decimalMode) {
        DecimalTypeDeserializer decimalDeserializer = (DecimalTypeDeserializer)CassandraTypeDeserializer.getInstance().DATATYPE_MAP.get(6);
        decimalDeserializer.setMode(decimalMode);
    }

    public static void setVarIntMode(VarIntMode varIntMode) {
        VarIntTypeDeserializer varIntDeserializer = (VarIntTypeDeserializer)CassandraTypeDeserializer.getInstance().DATATYPE_MAP.get(14);
        varIntDeserializer.setMode(varIntMode);
    }

    private static final class CassandraTypeDeserializerInstanceHolder {
        private static final CassandraTypeDeserializer instance = new CassandraTypeDeserializer();

        private CassandraTypeDeserializerInstanceHolder() {
        }
    }

    public static enum DecimalMode {
        PRECISE,
        DOUBLE,
        STRING;

    }

    public static enum VarIntMode {
        PRECISE,
        LONG,
        STRING;

    }
}

