/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.junit.Assert;
import org.junit.Test;

public class CassandraTypeConverterTest {
    @Test
    public void testAscii() {
        DataType asciiType = DataTypes.ASCII;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)asciiType);
        AsciiType expectedType = AsciiType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testBlob() {
        DataType blobType = DataTypes.BLOB;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)blobType);
        BytesType expectedType = BytesType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testBigInt() {
        DataType bigIntType = DataTypes.BIGINT;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)bigIntType);
        LongType expectedType = LongType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testBoolean() {
        DataType booleanType = DataTypes.BOOLEAN;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)booleanType);
        BooleanType expectedType = BooleanType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testCounter() {
        DataType counterType = DataTypes.COUNTER;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)counterType);
        CounterColumnType expectedType = CounterColumnType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testDate() {
        DataType dateType = DataTypes.DATE;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)dateType);
        SimpleDateType expectedType = SimpleDateType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testDecimal() {
        DataType decimalType = DataTypes.DECIMAL;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)decimalType);
        DecimalType expectedType = DecimalType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testDouble() {
        DataType doubleType = DataTypes.DOUBLE;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)doubleType);
        DoubleType expectedType = DoubleType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testDuration() {
        DataType durationType = DataTypes.DURATION;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)durationType);
        DurationType expectedType = DurationType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testFloat() {
        DataType floatType = DataTypes.FLOAT;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)floatType);
        FloatType expectedType = FloatType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testInet() {
        DataType inetType = DataTypes.INET;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)inetType);
        InetAddressType expectedType = InetAddressType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testInt() {
        DataType intType = DataTypes.INT;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)intType);
        Int32Type expectedType = Int32Type.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testList() {
        ListType listType = DataTypes.listOf((DataType)DataTypes.INT, (boolean)false);
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)listType);
        org.apache.cassandra.db.marshal.ListType expectedType = org.apache.cassandra.db.marshal.ListType.getInstance((AbstractType)Int32Type.instance, (boolean)true);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        listType = DataTypes.listOf((DataType)DataTypes.INT, (boolean)true);
        convertedType = CassandraTypeConverter.convert((DataType)listType);
        expectedType = org.apache.cassandra.db.marshal.ListType.getInstance((AbstractType)Int32Type.instance, (boolean)false);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        Assert.assertTrue((String)"Expected convertedType to be frozen", (boolean)convertedType.isFrozenCollection());
    }

    @Test
    public void testMap() {
        MapType mapType = DataTypes.mapOf((DataType)DataTypes.ASCII, (DataType)DataTypes.DOUBLE, (boolean)false);
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)mapType);
        org.apache.cassandra.db.marshal.MapType expectedType = org.apache.cassandra.db.marshal.MapType.getInstance((AbstractType)AsciiType.instance, (AbstractType)DoubleType.instance, (boolean)true);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        mapType = DataTypes.mapOf((DataType)DataTypes.ASCII, (DataType)DataTypes.DOUBLE, (boolean)true);
        convertedType = CassandraTypeConverter.convert((DataType)mapType);
        expectedType = org.apache.cassandra.db.marshal.MapType.getInstance((AbstractType)AsciiType.instance, (AbstractType)DoubleType.instance, (boolean)false);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        Assert.assertTrue((String)"Expected convertType to be frozen", (boolean)convertedType.isFrozenCollection());
    }

    @Test
    public void testSet() {
        SetType setType = DataTypes.setOf((DataType)DataTypes.FLOAT, (boolean)false);
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)setType);
        org.apache.cassandra.db.marshal.SetType expectedType = org.apache.cassandra.db.marshal.SetType.getInstance((AbstractType)FloatType.instance, (boolean)true);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        setType = DataTypes.setOf((DataType)DataTypes.FLOAT, (boolean)true);
        convertedType = CassandraTypeConverter.convert((DataType)setType);
        expectedType = org.apache.cassandra.db.marshal.SetType.getInstance((AbstractType)FloatType.instance, (boolean)false);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
        Assert.assertTrue((String)"Expected convertedType to be frozen", (boolean)convertedType.isFrozenCollection());
    }

    @Test
    public void testSmallInt() {
        DataType smallIntType = DataTypes.SMALLINT;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)smallIntType);
        ShortType expectedType = ShortType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testText() {
        DataType textType = DataTypes.TEXT;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)textType);
        UTF8Type expectedType = UTF8Type.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTime() {
        DataType timeType = DataTypes.TIME;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)timeType);
        TimeType expectedType = TimeType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTimestamp() {
        DataType timestampType = DataTypes.TIMESTAMP;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)timestampType);
        TimestampType expectedType = TimestampType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTimeUUID() {
        DataType timeUUID = DataTypes.TIMEUUID;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)timeUUID);
        TimeUUIDType expectedType = TimeUUIDType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTinyInt() {
        DataType tinyInt = DataTypes.TINYINT;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)tinyInt);
        ByteType expectedType = ByteType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testVarInt() {
        DataType varInt = DataTypes.VARINT;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)varInt);
        IntegerType expectedType = IntegerType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testTuple() {
        TupleType tupleType = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TIMESTAMP, DataTypes.SMALLINT});
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)tupleType);
        ArrayList<Object> innerAbstractTypes = new ArrayList<Object>(2);
        innerAbstractTypes.add(TimestampType.instance);
        innerAbstractTypes.add(ShortType.instance);
        org.apache.cassandra.db.marshal.TupleType expectedType = new org.apache.cassandra.db.marshal.TupleType(innerAbstractTypes);
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }

    @Test
    public void testUdt() {
        DefaultUserDefinedType nonFrozenUserDefinedType = new DefaultUserDefinedType(CqlIdentifier.fromCql((String)"ks1"), CqlIdentifier.fromInternal((String)"FooType"), false, Collections.singletonList(CqlIdentifier.fromCql((String)"field1")), Collections.singletonList(DataTypes.TEXT));
        DefaultUserDefinedType frozenUserDefinedType = new DefaultUserDefinedType(CqlIdentifier.fromCql((String)"ks1"), CqlIdentifier.fromInternal((String)"FooType"), true, Collections.singletonList(CqlIdentifier.fromCql((String)"field1")), Collections.singletonList(DataTypes.TEXT));
        ByteBuffer expectedTypeName = UTF8Type.instance.decompose((Object)"FooType");
        ArrayList<FieldIdentifier> expectedFieldIdentifiers = new ArrayList<FieldIdentifier>();
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("field1".getBytes(Charset.defaultCharset()))));
        ArrayList<UTF8Type> expectedFieldTypes = new ArrayList<UTF8Type>();
        expectedFieldTypes.add(UTF8Type.instance);
        UserType expectedAbstractType = new UserType("ks1", expectedTypeName, expectedFieldIdentifiers, expectedFieldTypes, true);
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)nonFrozenUserDefinedType);
        Assert.assertEquals((Object)expectedAbstractType, (Object)convertedType);
        expectedAbstractType = new UserType("ks1", expectedTypeName, expectedFieldIdentifiers, expectedFieldTypes, true).freeze();
        convertedType = CassandraTypeConverter.convert((DataType)frozenUserDefinedType);
        Assert.assertEquals((Object)expectedAbstractType, (Object)convertedType);
    }

    @Test
    public void testUUID() {
        DataType uuid = DataTypes.UUID;
        AbstractType convertedType = CassandraTypeConverter.convert((DataType)uuid);
        UUIDType expectedType = UUIDType.instance;
        Assert.assertEquals((Object)expectedType, (Object)convertedType);
    }
}

