/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import com.datastax.oss.driver.api.core.type.DataType;
import io.debezium.connector.cassandra.transforms.type.converter.BasicTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.ListTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.MapTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.SetTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.TupleTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.TypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.UserTypeConverter;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public final class CassandraTypeConverter {
    private static final Map<Integer, TypeConverter<?>> typeMap = new HashMap();

    private CassandraTypeConverter() {
    }

    public static AbstractType<?> convert(DataType type) {
        TypeConverter<?> typeConverter = typeMap.get(type.getProtocolCode());
        return typeConverter.convert(type);
    }

    static {
        typeMap.put(1, new BasicTypeConverter<AsciiType>(AsciiType.instance));
        typeMap.put(2, new BasicTypeConverter<LongType>(LongType.instance));
        typeMap.put(3, new BasicTypeConverter<BytesType>(BytesType.instance));
        typeMap.put(4, new BasicTypeConverter<BooleanType>(BooleanType.instance));
        typeMap.put(5, new BasicTypeConverter<CounterColumnType>(CounterColumnType.instance));
        typeMap.put(17, new BasicTypeConverter<SimpleDateType>(SimpleDateType.instance));
        typeMap.put(6, new BasicTypeConverter<DecimalType>(DecimalType.instance));
        typeMap.put(7, new BasicTypeConverter<DoubleType>(DoubleType.instance));
        typeMap.put(21, new BasicTypeConverter<DurationType>(DurationType.instance));
        typeMap.put(8, new BasicTypeConverter<FloatType>(FloatType.instance));
        typeMap.put(16, new BasicTypeConverter<InetAddressType>(InetAddressType.instance));
        typeMap.put(9, new BasicTypeConverter<Int32Type>(Int32Type.instance));
        typeMap.put(32, new ListTypeConverter());
        typeMap.put(33, new MapTypeConverter());
        typeMap.put(34, new SetTypeConverter());
        typeMap.put(19, new BasicTypeConverter<ShortType>(ShortType.instance));
        typeMap.put(13, new BasicTypeConverter<UTF8Type>(UTF8Type.instance));
        typeMap.put(18, new BasicTypeConverter<TimeType>(TimeType.instance));
        typeMap.put(11, new BasicTypeConverter<TimestampType>(TimestampType.instance));
        typeMap.put(15, new BasicTypeConverter<TimeUUIDType>(TimeUUIDType.instance));
        typeMap.put(20, new BasicTypeConverter<ByteType>(ByteType.instance));
        typeMap.put(49, new TupleTypeConverter());
        typeMap.put(48, new UserTypeConverter());
        typeMap.put(12, new BasicTypeConverter<UUIDType>(UUIDType.instance));
        typeMap.put(14, new BasicTypeConverter<IntegerType>(IntegerType.instance));
    }
}

