/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.converter;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.TypeConverter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;

public class UserTypeConverter
implements TypeConverter<UserType> {
    @Override
    public UserType convert(DataType dataType) {
        DefaultUserDefinedType userType = (DefaultUserDefinedType)dataType;
        String typeNameString = userType.getName().toString();
        List fieldNames = userType.getFieldNames().stream().map(CqlIdentifier::toString).collect(Collectors.toList());
        List fieldTypes = userType.getFieldTypes();
        HashMap<String, DataType> fieldNamesToTypes = new HashMap<String, DataType>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            fieldNamesToTypes.put((String)fieldNames.get(i), (DataType)fieldTypes.get(i));
        }
        ArrayList innerAbstractTypes = new ArrayList(fieldNames.size());
        ByteBuffer typeNameBuffer = UTF8Type.instance.fromString(typeNameString);
        ArrayList<FieldIdentifier> fieldIdentifiers = new ArrayList<FieldIdentifier>(fieldNames.size());
        for (String fieldName : fieldNames) {
            fieldIdentifiers.add(FieldIdentifier.forInternalString((String)fieldName));
            innerAbstractTypes.add(CassandraTypeConverter.convert((DataType)fieldNamesToTypes.get(fieldName)));
        }
        return new UserType(userType.getKeyspace().toString(), typeNameBuffer, fieldIdentifiers, innerAbstractTypes, !userType.isFrozen());
    }
}

