/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import io.debezium.config.Configuration;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.TestUtils;
import io.debezium.kafka.KafkaCluster;
import io.debezium.util.Testing;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

public abstract class CassandraConnectorTestBase {
    public static final String CASSANDRA_SERVER_DIR = "/var/lib/cassandra";
    private static final String cassandraDir = CassandraConnectorTestBase.createCassandraDir();
    private static final String dockerDir = System.getProperty("docker.dir", "docker");
    private static final Consumer<CreateContainerCmd> cmd = e -> e.getHostConfig().withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.bindPort((int)9042), new ExposedPort(9042))});
    @ClassRule
    public static GenericContainer cassandra = new GenericContainer((Future)new ImageFromDockerfile().withFileFromPath(".", new File(dockerDir).toPath())).withExposedPorts(new Integer[]{9042}).withStartupTimeout(Duration.ofMinutes(3L)).withCreateContainerCmdModifier(cmd).withFileSystemBind(cassandraDir, "/var/lib/cassandra", BindMode.READ_WRITE);
    private KafkaCluster kafkaCluster;
    private File kafkaDataDir;

    @BeforeClass
    public static void setUpClass() throws Exception {
        CassandraConnectorTestBase.waitForCql();
        TestUtils.createTestKeyspace();
    }

    @AfterClass
    public static void tearDownClass() throws IOException, InterruptedException {
        CassandraConnectorTestBase.destroyTestKeyspace("test_keyspace");
        CassandraConnectorTestBase.destroyTestKeyspace("test_keyspace2");
        cassandra.stop();
        GenericContainer clenaup = new GenericContainer((Future)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from("eclipse-temurin:8-jre-focal")).volume(new String[]{CASSANDRA_SERVER_DIR})).cmd(new String[]{"sleep", "10"})).build())).withFileSystemBind(cassandraDir, CASSANDRA_SERVER_DIR, BindMode.READ_WRITE);
        clenaup.start();
        clenaup.execInContainer(new String[]{"rm", "-rf", "/var/lib/cassandra/data", "/var/lib/cassandra/cdc_raw_directory", "/var/lib/cassandra/commitlog", "/var/lib/cassandra/hints", "/var/lib/cassandra/saved_caches"});
        clenaup.stop();
    }

    @Before
    public void beforeEach() throws Exception {
        this.kafkaDataDir = Testing.Files.createTestingDirectory((String)"kafkaCluster");
        Testing.Files.delete((File)this.kafkaDataDir);
        this.kafkaCluster = new KafkaCluster().usingDirectory(this.kafkaDataDir).deleteDataUponShutdown(true).addBrokers(1).withPorts(2181, 9092).startup();
    }

    @After
    public void afterEach() {
        this.kafkaCluster.shutdown();
        Testing.Files.delete((File)this.kafkaDataDir);
    }

    public static void destroyTestKeyspace() throws Exception {
        TestUtils.deleteTestKeyspaceTables("test_keyspace");
    }

    public static void destroyTestKeyspace(String keyspace) {
        try (CqlSession session = (CqlSession)CqlSession.builder().build();){
            session.execute((Statement)SchemaBuilder.dropKeyspace((String)keyspace).ifExists().build());
        }
    }

    protected abstract CassandraConnectorContext generateTaskContext(Configuration var1) throws Exception;

    protected CassandraConnectorContext generateTaskContext() throws Exception {
        return this.generateTaskContext(Configuration.from((Properties)TestUtils.generateDefaultConfigMap()));
    }

    protected CassandraConnectorContext generateTaskContext(Map<String, Object> configs) throws Exception {
        return this.generateTaskContext(Configuration.from(configs));
    }

    protected static void waitForCql() {
        Awaitility.await().pollInterval(10L, TimeUnit.SECONDS).pollInSameThread().timeout(1L, TimeUnit.MINUTES).until(() -> {
            Boolean bl;
            block8: {
                CqlSession ignored = (CqlSession)CqlSession.builder().build();
                try {
                    bl = true;
                    if (ignored == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                ignored.close();
            }
            return bl;
        });
    }

    protected static String createCassandraDir() {
        File cassandraDir = Testing.Files.createTestingDirectory((String)"cassandra");
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxrwxrwx");
        try {
            Files.setPosixFilePermissions(cassandraDir.toPath(), permissions);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return cassandraDir.toString();
    }
}

