/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class TupleTypeDeserializer
implements TypeDeserializer {
    private static final String TUPLE_NAME_POSTFIX = "Tuple";
    private static final String FIELD_NAME_PREFIX = "field";

    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        TupleType tupleType = (TupleType)abstractType;
        List innerTypes = tupleType.allTypes();
        ByteBuffer[] innerValueByteBuffers = tupleType.split(bb);
        Struct struct = new Struct(this.getSchemaBuilder(abstractType).build());
        for (int i = 0; i < innerTypes.size(); ++i) {
            AbstractType currentInnerType = (AbstractType)innerTypes.get(i);
            String fieldName = this.createFieldNameForIndex(i);
            Object deserializedInnerObject = CassandraTypeDeserializer.deserialize(currentInnerType, innerValueByteBuffers[i]);
            struct.put(fieldName, deserializedInnerObject);
        }
        return struct;
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        TupleType tupleType = (TupleType)abstractType;
        List tupleInnerTypes = tupleType.allTypes();
        String recordName = this.createTupleName(tupleInnerTypes);
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(recordName);
        for (int i = 0; i < tupleInnerTypes.size(); ++i) {
            AbstractType innerType = (AbstractType)tupleInnerTypes.get(i);
            schemaBuilder.field(this.createFieldNameForIndex(i), CassandraTypeDeserializer.getSchemaBuilder(innerType).build());
        }
        return schemaBuilder.optional();
    }

    private String createTupleName(List<AbstractType<?>> innerTypes) {
        StringBuilder tupleNameBuilder = new StringBuilder();
        for (AbstractType<?> innerType : innerTypes) {
            tupleNameBuilder.append(this.abstractTypeToNiceString(innerType));
        }
        return tupleNameBuilder.append(TUPLE_NAME_POSTFIX).toString();
    }

    private String createFieldNameForIndex(int i) {
        return FIELD_NAME_PREFIX + (i + 1);
    }

    private String abstractTypeToNiceString(AbstractType<?> tupleInnerType) {
        String typeName = tupleInnerType.getClass().getSimpleName();
        return typeName.substring(0, typeName.length() - 4);
    }
}

