/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TupleTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.UserDefinedTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public class ListTypeDeserializer
extends CollectionTypeDeserializer<ListType<?>> {
    private final DebeziumTypeDeserializer deserializer;

    public ListTypeDeserializer(DebeziumTypeDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        List<?> deserializedList = (List<?>)this.deserializer.deserialize(abstractType, bb);
        deserializedList = this.processElementsInDeserializedList(abstractType, deserializedList);
        return Values.convertToList((Schema)this.getSchemaBuilder(abstractType).build(), deserializedList);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        ListType listType = (ListType)abstractType;
        AbstractType elementsType = listType.getElementsType();
        Schema innerSchema = CassandraTypeDeserializer.getSchemaBuilder(elementsType).build();
        return SchemaBuilder.array((Schema)innerSchema).optional();
    }

    @Override
    public Object deserialize(ListType<?> listType, ComplexColumnData ccd) {
        List bbList = listType.serializedValues(ccd.iterator());
        AbstractType elementsType = listType.getElementsType();
        ArrayList<Object> deserializedList = new ArrayList<Object>(bbList.size());
        for (ByteBuffer bb : bbList) {
            deserializedList.add(CassandraTypeDeserializer.deserialize(elementsType, bb));
        }
        return Values.convertToList((Schema)this.getSchemaBuilder((AbstractType<?>)listType).build(), deserializedList);
    }

    private List<?> processElementsInDeserializedList(AbstractType<?> abstractType, List<?> deserializedList) {
        List<Object> resultedList;
        AbstractType elementsType = ((ListType)abstractType).getElementsType();
        TypeDeserializer elementsTypeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(elementsType);
        if (elementsTypeDeserializer instanceof LogicalTypeDeserializer) {
            resultedList = new ArrayList();
            for (Object element : deserializedList) {
                Object formattedElement = ((LogicalTypeDeserializer)elementsTypeDeserializer).formatDeserializedValue(elementsType, element);
                resultedList.add(formattedElement);
            }
        } else if (elementsTypeDeserializer instanceof UserDefinedTypeDeserializer || elementsTypeDeserializer instanceof TupleTypeDeserializer) {
            resultedList = new ArrayList();
            for (Object element : deserializedList) {
                Object deserializedElement = elementsTypeDeserializer.deserialize(elementsType, (ByteBuffer)element);
                resultedList.add(deserializedElement);
            }
        } else {
            resultedList = deserializedList;
        }
        return resultedList;
    }
}

