/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorSchemaException;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class KeyValueSchema {
    private static final String NAMESPACE = "io.debezium.connector.cassandra";
    private final TableMetadata tableMetadata;
    private final Schema keySchema;
    private final Schema valueSchema;

    KeyValueSchema(String kafkaTopicPrefix, TableMetadata tableMetadata, SourceInfoStructMaker sourceInfoStructMaker) {
        this.tableMetadata = tableMetadata;
        this.keySchema = this.getKeySchema(kafkaTopicPrefix, tableMetadata);
        this.valueSchema = this.getValueSchema(kafkaTopicPrefix, tableMetadata, sourceInfoStructMaker);
    }

    public TableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    private Schema getKeySchema(String kafkaTopicPrefix, TableMetadata tm) {
        if (tm == null) {
            return null;
        }
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name("io.debezium.connector.cassandra." + KeyValueSchema.getKeyName(kafkaTopicPrefix, tm));
        for (ColumnMetadata cm : tm.getPrimaryKey()) {
            AbstractType<?> convertedType = CassandraTypeConverter.convert(cm.getType());
            Schema colSchema = CassandraTypeDeserializer.getSchemaBuilder(convertedType).build();
            if (colSchema == null) continue;
            schemaBuilder.field(cm.getName().toString(), colSchema);
        }
        return schemaBuilder.build();
    }

    private Schema getValueSchema(String kafkaTopicPrefix, TableMetadata tm, SourceInfoStructMaker sourceInfoStructMaker) {
        if (tm == null) {
            return null;
        }
        return SchemaBuilder.struct().name("io.debezium.connector.cassandra." + KeyValueSchema.getValueName(kafkaTopicPrefix, tm)).field("ts_ms", Schema.INT64_SCHEMA).field("op", Schema.STRING_SCHEMA).field("source", sourceInfoStructMaker.schema()).field("after", RowData.rowSchema(tm)).build();
    }

    private static String getKeyName(String kafkaTopicPrefix, TableMetadata tm) {
        return kafkaTopicPrefix + "." + tm.getKeyspace() + "." + tm.getName() + ".Key";
    }

    private static String getValueName(String kafkaTopicPrefix, TableMetadata tm) {
        return kafkaTopicPrefix + "." + tm.getKeyspace() + "." + tm.getName() + ".Envelope";
    }

    public static Schema getFieldSchema(String fieldName, Schema schema) {
        if (schema.type().equals((Object)Schema.Type.STRUCT)) {
            return schema.field(fieldName).schema();
        }
        throw new CassandraConnectorSchemaException("Only STRUCT type is supported for this method, but encountered " + schema.type());
    }
}

