/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.github.nosan.embedded.cassandra.Cassandra;
import com.github.nosan.embedded.cassandra.CassandraBuilder;
import com.github.nosan.embedded.cassandra.Version;
import com.github.nosan.embedded.cassandra.commons.ClassPathResource;
import com.github.nosan.embedded.cassandra.commons.Resource;
import io.debezium.config.Configuration;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.TestUtils;
import io.debezium.kafka.KafkaCluster;
import io.debezium.util.Testing;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class CassandraConnectorTestBase {
    public static final String EMBEDDED_CASSANDRA_VERSION = System.getProperty("cassandra.version", "3.11.10");
    public static Cassandra cassandra;
    private static Path cassandraDir;
    private KafkaCluster kafkaCluster;
    private File kafkaDataDir;

    @BeforeClass
    public static void setUpClass() {
        cassandraDir = Testing.Files.createTestingDirectory((String)"embeddedCassandra").toPath();
        cassandra = CassandraConnectorTestBase.getCassandra(cassandraDir, EMBEDDED_CASSANDRA_VERSION);
        cassandra.start();
        CassandraConnectorTestBase.waitForCql();
        TestUtils.createTestKeyspace();
    }

    @AfterClass
    public static void tearDownClass() {
        CassandraConnectorTestBase.destroyTestKeyspace();
        cassandra.stop();
        Testing.Files.delete((Path)cassandraDir);
    }

    @Before
    public void beforeEach() throws Exception {
        this.kafkaDataDir = Testing.Files.createTestingDirectory((String)"kafkaCluster");
        Testing.Files.delete((File)this.kafkaDataDir);
        this.kafkaCluster = new KafkaCluster().usingDirectory(this.kafkaDataDir).deleteDataUponShutdown(true).addBrokers(1).withPorts(2181, 9092).startup();
    }

    @After
    public void afterEach() {
        this.kafkaCluster.shutdown();
        Testing.Files.delete((File)this.kafkaDataDir);
    }

    public static void destroyTestKeyspace() {
        try (CqlSession session = (CqlSession)CqlSession.builder().build();){
            session.execute((Statement)SchemaBuilder.dropKeyspace((String)"test_keyspace").build());
        }
    }

    protected abstract CassandraConnectorContext generateTaskContext(Configuration var1) throws Exception;

    protected CassandraConnectorContext generateTaskContext() throws Exception {
        return this.generateTaskContext(Configuration.from((Properties)TestUtils.generateDefaultConfigMap()));
    }

    protected CassandraConnectorContext generateTaskContext(Map<String, Object> configs) throws Exception {
        return this.generateTaskContext(Configuration.from(configs));
    }

    protected static Cassandra getCassandra(Path cassandraHome, String version) {
        return new CassandraBuilder().version(Version.parse((String)version)).jvmOptions(new String[]{"-Dcassandra.ring_delay_ms=1000", "-Xms1g", "-Xmx1g"}).workingDirectory(() -> cassandraHome).startupTimeout(Duration.ofMinutes(5L)).configFile((Resource)new ClassPathResource("cassandra-unit.yaml")).build();
    }

    protected static void waitForCql() {
        Awaitility.await().pollInterval(10L, TimeUnit.SECONDS).pollInSameThread().timeout(1L, TimeUnit.MINUTES).until(() -> {
            Boolean bl;
            block8: {
                CqlSession ignored = (CqlSession)CqlSession.builder().build();
                try {
                    bl = true;
                    if (ignored == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                ignored.close();
            }
            return bl;
        });
    }
}

