/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractAllocator {
    public ByteBuffer clone(ByteBuffer buffer) {
        return this.clone(buffer, ByteBufferAccessor.instance);
    }

    public ByteBuffer clone(byte[] bytes) {
        return this.clone(bytes, ByteArrayAccessor.instance);
    }

    public <V> ByteBuffer clone(V value, ValueAccessor<V> accessor) {
        assert (value != null);
        int size = accessor.size(value);
        if (size == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer cloned = this.allocate(size);
        cloned.mark();
        accessor.write(value, cloned);
        cloned.reset();
        return cloned;
    }

    public abstract ByteBuffer allocate(int var1);

    public Row.Builder cloningBTreeRowBuilder() {
        return new CloningBTreeRowBuilder(this);
    }

    private static class CloningBTreeRowBuilder
    extends BTreeRow.Builder {
        private final AbstractAllocator allocator;

        private CloningBTreeRowBuilder(AbstractAllocator allocator) {
            super(true);
            this.allocator = allocator;
        }

        @Override
        public void newRow(Clustering<?> clustering) {
            super.newRow(clustering.copy(this.allocator));
        }

        @Override
        public void addCell(Cell<?> cell) {
            super.addCell(cell.copy(this.allocator));
        }
    }
}

