/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.DebeziumException;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.CassandraConnectorContext;
import io.debezium.connector.cassandra.CommitLogIdxProcessor;
import io.debezium.connector.cassandra.CommitLogProcessingResult;
import io.debezium.connector.cassandra.CommitLogProcessorMetrics;
import io.debezium.connector.cassandra.CommitLogSegmentReader;
import io.debezium.connector.cassandra.CommitLogTransfer;
import io.debezium.connector.cassandra.EOFEvent;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.LogicalCommitLog;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import io.debezium.pipeline.Sizeable;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogIdxParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogIdxParser.class);
    private final CommitLogSegmentReader commitLogReader;
    private final List<ChangeEventQueue<Event>> queues;
    private final CommitLogProcessorMetrics metrics;
    private final CommitLogTransfer commitLogTransfer;
    private final Set<String> erroneousCommitLogs;
    private boolean completePrematurely = false;
    private final LogicalCommitLog commitLog;
    private final int pollingInterval;
    private final boolean realTimeProcessingEnabled;
    private Integer offset;

    public CommitLogIdxParser(LogicalCommitLog commitLog, CommitLogProcessorMetrics metrics, CassandraConnectorContext context, CommitLogSegmentReader commitLogReader) {
        this.queues = context.getQueues();
        this.metrics = metrics;
        this.commitLog = commitLog;
        this.commitLogReader = commitLogReader;
        this.commitLogTransfer = context.getCassandraConnectorConfig().getCommitLogTransfer();
        this.erroneousCommitLogs = context.getErroneousCommitLogs();
        this.pollingInterval = context.getCassandraConnectorConfig().getCommitLogMarkedCompletePollInterval();
        this.realTimeProcessingEnabled = context.getCassandraConnectorConfig().isCommitLogRealTimeProcessingEnabled();
    }

    public void complete() {
        this.completePrematurely = true;
    }

    private CommitLogProcessingResult parse() {
        try {
            this.parseIndexFile(this.commitLog);
            while (!this.commitLog.completed) {
                LOGGER.debug("Polling for completeness of idx file for: {}", (Object)this.commitLog);
                if (this.completePrematurely) {
                    LOGGER.warn("{} completed prematurely", (Object)this.commitLog);
                    return new CommitLogProcessingResult(this.commitLog, CommitLogProcessingResult.Result.COMPLETED_PREMATURELY);
                }
                if (this.realTimeProcessingEnabled) {
                    Integer commitLogPosition;
                    if (this.offset == null) {
                        LOGGER.debug("Start to read the partial file : {}", (Object)this.commitLog);
                        commitLogPosition = 0;
                    } else if (this.offset < this.commitLog.offsetOfEndOfLastWrittenCDCMutation) {
                        LOGGER.debug("Resume to read the partial file: {}", (Object)this.commitLog);
                        commitLogPosition = this.offset;
                    } else {
                        LOGGER.debug("No movement in offset in idx file: {}", (Object)this.commitLog);
                        commitLogPosition = null;
                    }
                    if (commitLogPosition != null) {
                        this.metrics.setCommitLogPosition(commitLogPosition.intValue());
                        this.processCommitLog(this.commitLog, commitLogPosition);
                        this.offset = this.commitLog.offsetOfEndOfLastWrittenCDCMutation;
                    }
                }
                LOGGER.debug("Sleep for idx file to be complete");
                Thread.sleep(this.pollingInterval);
                this.parseIndexFile(this.commitLog);
            }
            LOGGER.info("Completed idx file for: {}", (Object)this.commitLog);
            int commitLogPosition = this.offset == null ? 0 : this.offset;
            this.metrics.setCommitLogPosition(commitLogPosition);
            this.processCommitLog(this.commitLog, commitLogPosition);
            return new CommitLogProcessingResult(this.commitLog);
        }
        catch (Exception ex) {
            LOGGER.error("Processing of {} errored out", (Object)this.commitLog, (Object)ex);
            return new CommitLogProcessingResult(this.commitLog, CommitLogProcessingResult.Result.ERROR, ex);
        }
    }

    public CommitLogProcessingResult process() {
        if (!this.commitLog.exists()) {
            LOGGER.warn("Commit log " + String.valueOf(this.commitLog) + " does not exist!");
            return new CommitLogProcessingResult(this.commitLog, CommitLogProcessingResult.Result.DOES_NOT_EXIST);
        }
        LOGGER.info("Processing commit log {}", (Object)this.commitLog.log.toString());
        this.metrics.setCommitLogFilename(this.commitLog.log.toString());
        this.metrics.setCommitLogPosition(0L);
        CommitLogProcessingResult result = this.parse();
        if (result.result == CommitLogProcessingResult.Result.OK || result.result == CommitLogProcessingResult.Result.ERROR) {
            this.enqueueEOFEvent();
        }
        CommitLogIdxProcessor.removeProcessing(this);
        LOGGER.debug("Processing {} callables.", (Object)CommitLogIdxProcessor.submittedProcessings.size());
        return result;
    }

    private void enqueueEOFEvent() {
        try {
            this.queues.get(Math.abs(this.commitLog.log.getName().hashCode() % this.queues.size())).enqueue((Sizeable)new EOFEvent(this.commitLog.log));
        }
        catch (InterruptedException e) {
            throw new CassandraConnectorTaskException(String.format("Enqueuing has been interrupted while enqueuing EOF Event for file %s", this.commitLog.log.getName()), e);
        }
    }

    private void processCommitLog(LogicalCommitLog logicalCommitLog, int position) {
        try {
            LOGGER.debug("Starting to read commit log segments {} on position {}", (Object)logicalCommitLog, (Object)position);
            this.commitLogReader.readCommitLogSegment(logicalCommitLog.log, logicalCommitLog.commitLogSegmentId, position);
            LOGGER.debug("Finished reading commit log segments {} on position {}", (Object)logicalCommitLog, (Object)position);
        }
        catch (Exception e) {
            if (this.commitLogTransfer.getClass().getName().equals("io.debezium.connector.cassandra.BlackHoleCommitLogTransfer")) {
                throw new DebeziumException(String.format("Error occurred while processing commit log %s", logicalCommitLog.log), (Throwable)e);
            }
            LOGGER.error("Error occurred while processing commit log " + String.valueOf(logicalCommitLog.log), (Throwable)e);
            this.erroneousCommitLogs.add(logicalCommitLog.log.getName());
            this.enqueueEOFEvent();
        }
    }

    private void parseIndexFile(LogicalCommitLog commitLog) throws DebeziumException {
        try {
            commitLog.parseCommitLogIndex();
        }
        catch (DebeziumException ex) {
            this.erroneousCommitLogs.add(commitLog.log.getName());
            throw ex;
        }
    }
}

