/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.streaming.DefaultConnectionFactory;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamCoordinator;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamException;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamResultFuture
extends AbstractFuture<StreamState> {
    private static final Logger logger = LoggerFactory.getLogger(StreamResultFuture.class);
    public final UUID planId;
    public final StreamOperation streamOperation;
    private final StreamCoordinator coordinator;
    private final Collection<StreamEventHandler> eventListeners = new ConcurrentLinkedQueue<StreamEventHandler>();

    private StreamResultFuture(UUID planId, StreamOperation streamOperation, StreamCoordinator coordinator) {
        this.planId = planId;
        this.streamOperation = streamOperation;
        this.coordinator = coordinator;
        if (!coordinator.isFollower() && !coordinator.hasActiveSessions()) {
            this.set(this.getCurrentState());
        }
    }

    private StreamResultFuture(UUID planId, StreamOperation streamOperation, UUID pendingRepair, PreviewKind previewKind) {
        this(planId, streamOperation, new StreamCoordinator(streamOperation, 0, new DefaultConnectionFactory(), true, false, pendingRepair, previewKind));
    }

    public static StreamResultFuture createInitiator(UUID planId, StreamOperation streamOperation, Collection<StreamEventHandler> listeners, StreamCoordinator coordinator) {
        StreamResultFuture future = StreamResultFuture.createAndRegisterInitiator(planId, streamOperation, coordinator);
        if (listeners != null) {
            for (StreamEventHandler listener : listeners) {
                future.addEventListener(listener);
            }
        }
        logger.info("[Stream #{}] Executing streaming plan for {}", (Object)planId, (Object)streamOperation.getDescription());
        for (StreamSession session : coordinator.getAllStreamSessions()) {
            session.init(future);
        }
        coordinator.connect(future);
        return future;
    }

    public static synchronized StreamResultFuture createFollower(int sessionIndex, UUID planId, StreamOperation streamOperation, InetAddressAndPort from, Channel channel, UUID pendingRepair, PreviewKind previewKind) {
        StreamResultFuture future = StreamManager.instance.getReceivingStream(planId);
        if (future == null) {
            logger.info("[Stream #{} ID#{}] Creating new streaming plan for {} from {} channel.remote {} channel.local {} channel.id {}", new Object[]{planId, sessionIndex, streamOperation.getDescription(), from, channel.remoteAddress(), channel.localAddress(), channel.id()});
            future = new StreamResultFuture(planId, streamOperation, pendingRepair, previewKind);
            StreamManager.instance.registerFollower(future);
        }
        future.attachConnection(from, sessionIndex, channel);
        logger.info("[Stream #{}, ID#{}] Received streaming plan for {} from {} channel.remote {} channel.local {} channel.id {}", new Object[]{planId, sessionIndex, streamOperation.getDescription(), from, channel.remoteAddress(), channel.localAddress(), channel.id()});
        return future;
    }

    private static StreamResultFuture createAndRegisterInitiator(UUID planId, StreamOperation streamOperation, StreamCoordinator coordinator) {
        StreamResultFuture future = new StreamResultFuture(planId, streamOperation, coordinator);
        StreamManager.instance.registerInitiator(future);
        return future;
    }

    public StreamCoordinator getCoordinator() {
        return this.coordinator;
    }

    private void attachConnection(InetAddressAndPort from, int sessionIndex, Channel channel) {
        StreamSession session = this.coordinator.getOrCreateSessionById(from, sessionIndex);
        session.init(this);
    }

    public void addEventListener(StreamEventHandler listener) {
        Futures.addCallback((ListenableFuture)this, (FutureCallback)listener, (Executor)MoreExecutors.directExecutor());
        this.eventListeners.add(listener);
    }

    public StreamState getCurrentState() {
        return new StreamState(this.planId, this.streamOperation, this.coordinator.getAllSessionInfo());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StreamResultFuture that = (StreamResultFuture)((Object)o);
        return this.planId.equals(that.planId);
    }

    public int hashCode() {
        return this.planId.hashCode();
    }

    void handleSessionPrepared(StreamSession session) {
        SessionInfo sessionInfo = session.getSessionInfo();
        logger.info("[Stream #{} ID#{}] Prepare completed. Receiving {} files({}), sending {} files({})", new Object[]{session.planId(), session.sessionIndex(), sessionInfo.getTotalFilesToReceive(), FBUtilities.prettyPrintMemory(sessionInfo.getTotalSizeToReceive()), sessionInfo.getTotalFilesToSend(), FBUtilities.prettyPrintMemory(sessionInfo.getTotalSizeToSend())});
        StreamEvent.SessionPreparedEvent event = new StreamEvent.SessionPreparedEvent(this.planId, sessionInfo);
        this.coordinator.addSessionInfo(sessionInfo);
        this.fireStreamEvent(event);
    }

    void handleSessionComplete(StreamSession session) {
        logger.info("[Stream #{}] Session with {} is complete", (Object)session.planId(), (Object)session.peer);
        this.fireStreamEvent(new StreamEvent.SessionCompleteEvent(session));
        SessionInfo sessionInfo = session.getSessionInfo();
        this.coordinator.addSessionInfo(sessionInfo);
        this.maybeComplete();
    }

    public void handleProgress(ProgressInfo progress) {
        this.coordinator.updateProgress(progress);
        this.fireStreamEvent(new StreamEvent.ProgressEvent(this.planId, progress));
    }

    synchronized void fireStreamEvent(StreamEvent event) {
        for (StreamEventHandler listener : this.eventListeners) {
            listener.handleStreamEvent(event);
        }
    }

    private synchronized void maybeComplete() {
        if (this.finishedAllSessions()) {
            StreamState finalState = this.getCurrentState();
            if (finalState.hasFailedSession()) {
                logger.warn("[Stream #{}] Stream failed", (Object)this.planId);
                this.setException(new StreamException(finalState, "Stream failed"));
            } else {
                logger.info("[Stream #{}] All sessions completed", (Object)this.planId);
                this.set(finalState);
            }
        }
    }

    public StreamSession getSession(InetAddressAndPort peer, int sessionIndex) {
        return this.coordinator.getSessionById(peer, sessionIndex);
    }

    private boolean finishedAllSessions() {
        return this.coordinator.getAllSessionInfo().stream().allMatch(s -> s.state.isFinalState());
    }
}

