/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveLongCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class BigIntCodec
implements PrimitiveLongCodec {
    @Override
    @NonNull
    public GenericType<Long> getJavaType() {
        return GenericType.LONG;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.BIGINT;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof Long;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Long.class || javaClass == Long.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(long value, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes = ByteBuffer.allocate(8);
        bytes.putLong(0, value);
        return bytes;
    }

    @Override
    public long decodePrimitive(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return 0L;
        }
        if (bytes.remaining() != 8) {
            throw new IllegalArgumentException("Invalid 64-bits long value, expecting 8 bytes but got " + bytes.remaining());
        }
        return bytes.getLong(bytes.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Long value) {
        return value == null ? "NULL" : Long.toString(value);
    }

    @Override
    @Nullable
    public Long parse(@Nullable String value) {
        try {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Long.valueOf(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 64-bits long value from \"%s\"", value));
        }
    }
}

