/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import io.debezium.DebeziumException;
import io.debezium.connector.cassandra.KafkaRecord;
import io.debezium.connector.cassandra.KeyValueSchema;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.schema.SchemaFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class CassandraSchemaFactory
extends SchemaFactory {
    public static final String ROW_SCHEMA_NAME = "after";
    public static final int ROW_SCHEMA_VERSION = 1;
    public static final String CELL_SCHEMA_NAME = "cell_value";
    public static final int CELL_SCHEMA_VERSION = 1;
    public static final String RANGE_START_SCHEMA_NAME = "_range_start";
    public static final int RANGE_START_SCHEMA_VERSION = 1;
    public static final String RANGE_END_SCHEMA_NAME = "_range_end";
    public static final int RANGE_END_SCHEMA_VERSION = 1;
    public static final String RANGE_TOMBSTONE_CLUSTERING_VALUES_SCHEMA_NAME = "clustering_values";
    public static final int RANGE_TOMBSTONE_CLUSTERING_VALUES_SCHEMA_VERSION = 1;
    public static final String RANGE_TOMBSTONE_CLUSTERING_VALUE_SCHEMA_NAME = "clustering_value";
    public static final int RANGE_TOMBSTONE_CLUSTERING_VALUE_SCHEMA_VERSION = 1;
    private static final CassandraSchemaFactory cassandraSchemaFactoryObject = new CassandraSchemaFactory();

    public static CassandraSchemaFactory get() {
        return cassandraSchemaFactoryObject;
    }

    public RowData rowData() {
        return new RowData();
    }

    public CellData cellData(String name, Object value, Object deletionTs, CellData.ColumnType columnType) {
        return new CellData(name, value, deletionTs, columnType);
    }

    public RangeData rangeData(String name, String method, Map<String, Pair<String, String>> values) {
        return new RangeData(name, method, values);
    }

    public static class RowData
    implements KafkaRecord {
        private final Map<String, CellData> cellMap = new LinkedHashMap<String, CellData>();
        private RangeData startRange = null;
        private RangeData endRange = null;

        private RowData() {
        }

        public void addStartRange(RangeData startRange) {
            this.startRange = startRange;
        }

        public void addEndRange(RangeData endRange) {
            this.endRange = endRange;
        }

        public RangeData getStartRange() {
            return this.startRange;
        }

        public RangeData getEndRange() {
            return this.endRange;
        }

        public void addCell(CellData cellData) {
            this.cellMap.put(cellData.name, cellData);
        }

        public void removeCell(String columnName) {
            if (this.hasCell(columnName)) {
                this.cellMap.remove(columnName);
            }
        }

        public boolean hasCell(String columnName) {
            return this.cellMap.containsKey(columnName);
        }

        public boolean hasAnyCell() {
            return !this.cellMap.isEmpty();
        }

        @Override
        public Struct record(Schema schema) {
            Struct struct = new Struct(schema);
            for (Field field : schema.fields()) {
                Schema cellSchema = KeyValueSchema.getFieldSchema(field.name(), schema);
                if (field.name().equals(CassandraSchemaFactory.RANGE_START_SCHEMA_NAME) && this.startRange != null) {
                    struct.put(field.name(), (Object)this.startRange.record(cellSchema));
                    continue;
                }
                if (field.name().equals(CassandraSchemaFactory.RANGE_END_SCHEMA_NAME) && this.endRange != null) {
                    struct.put(field.name(), (Object)this.endRange.record(cellSchema));
                    continue;
                }
                CellData cellData = this.cellMap.get(field.name());
                if (cellData == null) continue;
                struct.put(field.name(), (Object)cellData.record(cellSchema));
            }
            return struct;
        }

        public RowData copy() {
            RowData copy = new RowData();
            for (CellData cellData : this.cellMap.values()) {
                copy.addCell(cellData);
            }
            return copy;
        }

        static Schema rowSchema(TableMetadata tm) {
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<DataType> columnTypes = new ArrayList<DataType>();
            for (ColumnMetadata cm : tm.getColumns().values()) {
                columnNames.add(cm.getName().toString());
                columnTypes.add(cm.getType());
            }
            return RowData.rowSchema(columnNames, columnTypes);
        }

        static Schema rowSchema(List<String> columnNames, List<DataType> columnsTypes) {
            SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(CassandraSchemaFactory.ROW_SCHEMA_NAME).version(Integer.valueOf(1));
            for (int i = 0; i < columnNames.size(); ++i) {
                Schema valueSchema = CassandraTypeDeserializer.getSchemaBuilder(columnsTypes.get(i)).build();
                String columnName = columnNames.get(i);
                Schema optionalCellSchema = CellData.cellSchema(valueSchema, true);
                if (optionalCellSchema == null) continue;
                schemaBuilder.field(columnName, optionalCellSchema);
            }
            schemaBuilder.field(CassandraSchemaFactory.RANGE_START_SCHEMA_NAME, RangeData.rangeStartSchema());
            schemaBuilder.field(CassandraSchemaFactory.RANGE_END_SCHEMA_NAME, RangeData.rangeEndSchema());
            return schemaBuilder.build();
        }

        public List<CellData> getPrimary() {
            return this.cellMap.values().stream().filter(CellData::isPrimary).collect(Collectors.toList());
        }

        public String toString() {
            return this.cellMap.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowData rowData = (RowData)o;
            return Objects.equals(this.cellMap, rowData.cellMap);
        }

        public int hashCode() {
            return Objects.hash(this.cellMap);
        }
    }

    public static class CellData
    implements KafkaRecord {
        public static final String CELL_VALUE_KEY = "value";
        public static final String CELL_DELETION_TS_KEY = "deletion_ts";
        public static final String CELL_SET_KEY = "set";
        public final String name;
        public final Object value;
        public final Object deletionTs;
        public final ColumnType columnType;

        private CellData(String name, Object value, Object deletionTs, ColumnType columnType) {
            this.name = name;
            this.value = value;
            this.deletionTs = deletionTs;
            this.columnType = columnType;
        }

        public boolean isPrimary() {
            return this.columnType == ColumnType.PARTITION || this.columnType == ColumnType.CLUSTERING;
        }

        @Override
        public Struct record(Schema schema) {
            try {
                return new Struct(schema).put(CELL_DELETION_TS_KEY, this.deletionTs).put(CELL_SET_KEY, (Object)true).put(CELL_VALUE_KEY, this.value);
            }
            catch (DataException e) {
                throw new DebeziumException(String.format("Failed to record Cell. Name: %s, Schema: %s, Value: %s", this.name, schema.toString(), this.value), (Throwable)e);
            }
        }

        static Schema cellSchema(Schema columnSchema, boolean optional) {
            if (columnSchema == null) {
                return null;
            }
            SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(CassandraSchemaFactory.CELL_SCHEMA_NAME).version(Integer.valueOf(1)).field(CELL_VALUE_KEY, columnSchema).field(CELL_DELETION_TS_KEY, Schema.OPTIONAL_INT64_SCHEMA).field(CELL_SET_KEY, Schema.BOOLEAN_SCHEMA);
            if (optional) {
                schemaBuilder.optional();
            }
            return schemaBuilder.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellData that = (CellData)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && this.deletionTs == that.deletionTs && this.columnType == that.columnType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.value, this.deletionTs, this.columnType});
        }

        public String toString() {
            return "{name=" + this.name + ", value=" + String.valueOf(this.value) + ", deletionTs=" + String.valueOf(this.deletionTs) + ", type=" + this.columnType.name() + "}";
        }

        public static enum ColumnType {
            PARTITION,
            CLUSTERING,
            REGULAR;

        }
    }

    public static class RangeData
    implements KafkaRecord {
        public static final String RANGE_START_NAME = "_range_start";
        public static final String RANGE_END_NAME = "_range_end";
        public static final String RANGE_METHOD_FIELD_NAME = "method";
        public static final String RANGE_VALUES_FIELD_NAME = "values";
        public static final String RANGE_CLUSTERING_VALUE_ITEM_NAME_FIELD_NAME = "name";
        public static final String RANGE_CLUSTERING_VALUE_ITEM_VALUE_FIELD_NAME = "value";
        public static final String RANGE_CLUSTERING_VALUE_ITEM_TYPE_FIELD_NAME = "type";
        public final String name;
        public final String method;
        public final Map<String, Pair<String, String>> values = new HashMap<String, Pair<String, String>>();
        static Schema clusteringValue = SchemaBuilder.struct().version(Integer.valueOf(1)).name("clustering_value").field("name", Schema.STRING_SCHEMA).field("value", Schema.STRING_SCHEMA).field("type", Schema.STRING_SCHEMA).build();
        static Schema clusteringValues = SchemaBuilder.array((Schema)clusteringValue).name("clustering_values").version(Integer.valueOf(1)).build();

        private RangeData(String name, String method, Map<String, Pair<String, String>> values) {
            if (name == null) {
                throw new IllegalArgumentException("Name of range can not be null!");
            }
            if (!name.equals("_range_start") && !name.equals("_range_end")) {
                throw new IllegalArgumentException(String.format("Value of name parameter has to be either %s or %s", "_range_start", "_range_end"));
            }
            this.name = name;
            this.method = method;
            if (values != null) {
                this.values.putAll(values);
            }
        }

        public static RangeData start(String method, Map<String, Pair<String, String>> values) {
            return CassandraSchemaFactory.get().rangeData("_range_start", method, values);
        }

        public static RangeData end(String method, Map<String, Pair<String, String>> values) {
            return CassandraSchemaFactory.get().rangeData("_range_end", method, values);
        }

        static List<Struct> mapValues(Map<String, Pair<String, String>> values) {
            return values.entrySet().stream().map(entry -> new Struct(clusteringValue).put(RANGE_CLUSTERING_VALUE_ITEM_NAME_FIELD_NAME, entry.getKey()).put(RANGE_CLUSTERING_VALUE_ITEM_VALUE_FIELD_NAME, ((Pair)entry.getValue()).getLeft()).put(RANGE_CLUSTERING_VALUE_ITEM_TYPE_FIELD_NAME, ((Pair)entry.getValue()).getRight())).collect(Collectors.toList());
        }

        static Schema rangeStartSchema() {
            return RangeData.rangeSchema("_range_start", 1);
        }

        static Schema rangeEndSchema() {
            return RangeData.rangeSchema("_range_end", 1);
        }

        private static Schema rangeSchema(String name, int version) {
            return SchemaBuilder.struct().name(name).version(Integer.valueOf(version)).field(RANGE_METHOD_FIELD_NAME, Schema.STRING_SCHEMA).field(RANGE_VALUES_FIELD_NAME, clusteringValues).optional().build();
        }

        @Override
        public Struct record(Schema schema) {
            try {
                return new Struct(schema).put(RANGE_METHOD_FIELD_NAME, (Object)this.method).put(RANGE_VALUES_FIELD_NAME, RangeData.mapValues(this.values));
            }
            catch (DataException e) {
                throw new DebeziumException(String.format("Failed to record Range. Name: %s, Schema: %s, Method: %s, Values: %s", this.name, schema.toString(), this.method, this.values), (Throwable)e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangeData that = (RangeData)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.method, that.method) && this.values.equals(that.values);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.method, this.values);
        }

        public String toString() {
            return "{name=" + this.name + ", method=" + this.method + ", values=" + String.valueOf(this.values) + "}";
        }
    }
}

