/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CassandraPartition
implements Partition {
    private final String nodeId;
    private final String logicalName;
    private final Map<String, String> sourcePartition;
    private final int hashCode;

    private CassandraPartition(String logicalName, String nodeId) {
        this.logicalName = logicalName;
        this.nodeId = nodeId;
        this.sourcePartition = Collect.hashMapOf((Object)"logicalName", (Object)logicalName, (Object)"nodeId", (Object)nodeId);
        this.hashCode = Objects.hash(logicalName, nodeId);
    }

    public Map<String, String> getSourcePartition() {
        return this.sourcePartition;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraPartition other = (CassandraPartition)obj;
        return Objects.equals(this.logicalName, other.logicalName) && Objects.equals(this.nodeId, other.nodeId);
    }

    public static class Provider
    implements Partition.Provider<CassandraPartition> {
        private final CassandraConnectorConfig connectorConfig;

        public Provider(CassandraConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<CassandraPartition> getPartitions() {
            return Collections.singleton(new CassandraPartition(this.connectorConfig.getLogicalName(), this.connectorConfig.getNodeId()));
        }
    }
}

