/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import java.util.Objects;

public class Difference {
    private final String fullPath;
    private final Type type;

    public Difference(Type type, String fullPath) {
        this.fullPath = fullPath;
        this.type = type;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Difference that = (Difference)o;
        return Objects.equals(this.fullPath, that.fullPath) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fullPath, this.type});
    }

    public String toString() {
        return "Difference{fullPath='" + this.fullPath + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        PACKAGE_CHANGED,
        MESSAGE_ADDED,
        MESSAGE_REMOVED,
        MESSAGE_MOVED,
        ENUM_ADDED,
        ENUM_REMOVED,
        ENUM_CONST_ADDED,
        ENUM_CONST_CHANGED,
        ENUM_CONST_REMOVED,
        FIELD_ADDED,
        FIELD_REMOVED,
        FIELD_NAME_CHANGED,
        FIELD_KIND_CHANGED,
        FIELD_SCALAR_KIND_CHANGED,
        FIELD_NAMED_TYPE_CHANGED,
        FIELD_NUMERIC_LABEL_CHANGED,
        FIELD_STRING_OR_BYTES_LABEL_CHANGED,
        ONEOF_ADDED,
        ONEOF_REMOVED,
        ONEOF_FIELD_ADDED,
        ONEOF_FIELD_REMOVED,
        MULTIPLE_FIELDS_MOVED_TO_ONEOF;

    }
}

