/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;

public class RepairedState {
    private volatile State state = new State(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    State state() {
        return this.state;
    }

    private static List<Section> levelsToSections(List<Level> levels) {
        ArrayList<Section> sections = new ArrayList<Section>();
        for (Level level : levels) {
            for (Range<Token> range : level.ranges) {
                sections.add(new Section(range, level.repairedAt));
            }
        }
        sections.sort(Section.tokenComparator);
        return sections;
    }

    public synchronized void add(Collection<Range<Token>> ranges, long repairedAt) {
        Level newLevel = new Level(ranges, repairedAt);
        State lastState = this.state;
        ArrayList<Level> tmp = new ArrayList<Level>(lastState.levels.size() + 1);
        tmp.addAll((Collection<Level>)lastState.levels);
        tmp.add(newLevel);
        tmp.sort(Level.timeComparator);
        ArrayList<Level> levels = new ArrayList<Level>(lastState.levels.size() + 1);
        List covered = new ArrayList();
        for (Level level : tmp) {
            Level subtracted = level.subtract(covered);
            if (subtracted == null) continue;
            levels.add(subtracted);
            covered.addAll(subtracted.ranges);
            covered = Range.normalize(covered);
        }
        ArrayList<Section> sections = new ArrayList<Section>();
        for (Level level : levels) {
            for (Range<Token> range : level.ranges) {
                sections.add(new Section(range, level.repairedAt));
            }
        }
        sections.sort(Section.tokenComparator);
        this.state = new State(levels, covered, sections);
    }

    public long minRepairedAt(Collection<Range<Token>> ranges) {
        State current = this.state;
        Set remainingRanges = new HashSet(ranges);
        long minTime = Long.MAX_VALUE;
        for (Section section : current.sections) {
            if (((AbstractBounds)section.range).intersects(remainingRanges)) {
                minTime = Math.min(minTime, section.repairedAt);
                remainingRanges = Range.subtract(remainingRanges, Collections.singleton(section.range));
            }
            if (!remainingRanges.isEmpty()) continue;
            break;
        }
        return remainingRanges.isEmpty() ? minTime : 0L;
    }

    static List<Section> getRepairedStats(List<Section> sections, Collection<Range<Token>> ranges) {
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Object> remaining = Sets.newHashSet(Range.normalize(ranges));
        ArrayList<Section> results = new ArrayList<Section>();
        for (Section section : sections) {
            if (remaining.isEmpty()) break;
            Set<Range<Range>> sectionRanges = Range.rangeSet(section.range);
            for (Range range : remaining) {
                if (sectionRanges.isEmpty()) break;
                HashSet<Range<Range>> intersection = new HashSet<Range<Range>>();
                sectionRanges.forEach(r -> intersection.addAll(r.intersectionWith(range)));
                if (intersection.isEmpty()) continue;
                intersection.forEach(r -> results.add(section.makeSubsection((Range<Token>)r)));
                sectionRanges = Range.subtract(sectionRanges, intersection);
            }
            remaining = Range.subtract(remaining, Collections.singleton(section.range));
        }
        remaining.forEach(r -> results.add(new Section((Range<Token>)r, 0L)));
        results.sort(Section.tokenComparator);
        return results;
    }

    public Stats getRepairedStats(Collection<Range<Token>> ranges) {
        List<Section> sections = RepairedState.getRepairedStats(this.state.sections, ranges);
        if (sections.isEmpty()) {
            return new Stats(0L, 0L, Collections.emptyList());
        }
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        for (Section section : sections) {
            minTime = Math.min(minTime, section.repairedAt);
            maxTime = Math.max(maxTime, section.repairedAt);
        }
        return new Stats(minTime, maxTime, sections);
    }

    static class State {
        final ImmutableList<Level> levels;
        final ImmutableList<Range<Token>> covered;
        final ImmutableList<Section> sections;

        State(List<Level> levels, List<Range<Token>> covered, List<Section> sections) {
            this.levels = ImmutableList.copyOf(levels);
            this.covered = ImmutableList.copyOf(covered);
            this.sections = ImmutableList.copyOf(sections);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return Objects.equals(this.levels, state.levels) && Objects.equals(this.covered, state.covered);
        }

        public int hashCode() {
            return Objects.hash(this.levels, this.covered);
        }

        public String toString() {
            return "State{levels=" + this.levels + ", covered=" + this.covered + '}';
        }
    }

    public static class Stats {
        public static final Stats EMPTY = new Stats(0L, 0L, Collections.emptyList());
        public final long minRepaired;
        public final long maxRepaired;
        public final List<Section> sections;

        public Stats(long minRepaired, long maxRepaired, List<Section> sections) {
            this.minRepaired = minRepaired;
            this.maxRepaired = maxRepaired;
            this.sections = sections;
        }
    }

    public static class Section {
        public final Range<Token> range;
        public final long repairedAt;
        private static final Comparator<Section> tokenComparator = (l, r) -> ((Token)l.range.left).compareTo(r.range.left);

        Section(Range<Token> range, long repairedAt) {
            this.range = range;
            this.repairedAt = repairedAt;
        }

        Section makeSubsection(Range<Token> subrange) {
            Preconditions.checkArgument((boolean)this.range.contains((Token)((Object)subrange)));
            return new Section(subrange, this.repairedAt);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Section section = (Section)o;
            return this.repairedAt == section.repairedAt && Objects.equals(this.range, section.range);
        }

        public int hashCode() {
            return Objects.hash(this.range, this.repairedAt);
        }

        public String toString() {
            return "Section{range=" + this.range + ", repairedAt=" + this.repairedAt + '}';
        }
    }

    static class Level {
        final List<Range<Token>> ranges;
        final long repairedAt;
        private static final Comparator<Level> timeComparator = Comparator.comparingLong(l -> -l.repairedAt);

        Level(Collection<Range<Token>> ranges, long repairedAt) {
            this.ranges = Range.normalize(ranges);
            this.repairedAt = repairedAt;
        }

        Level subtract(Collection<Range<Token>> ranges) {
            if (ranges.isEmpty()) {
                return this;
            }
            Set<Range<Token>> difference = Range.subtract(this.ranges, ranges);
            if (difference.isEmpty()) {
                return null;
            }
            return new Level(difference, this.repairedAt);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Level level = (Level)o;
            return this.repairedAt == level.repairedAt && Objects.equals(this.ranges, level.ranges);
        }

        public int hashCode() {
            return Objects.hash(this.ranges, this.repairedAt);
        }

        public String toString() {
            return "Level{ranges=" + this.ranges + ", repairedAt=" + this.repairedAt + '}';
        }
    }
}

