/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.AbstractReadQuery;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;

public abstract class VirtualTableReadQuery
extends AbstractReadQuery {
    protected VirtualTableReadQuery(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits) {
        super(metadata, nowInSec, columnFilter, rowFilter, limits);
    }

    @Override
    public ReadExecutionController executionController() {
        return ReadExecutionController.empty();
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) throws RequestExecutionException {
        return this.executeInternal(this.executionController());
    }

    @Override
    public UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController) {
        UnfilteredPartitionIterator resultIterator = this.queryVirtualTable();
        return this.limits().filter(this.rowFilter().filter(resultIterator, this.nowInSec()), this.nowInSec(), this.selectsFullPartition());
    }

    protected abstract UnfilteredPartitionIterator queryVirtualTable();
}

