/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GlobHelper {
    public static Pattern translate(String pattern, String separator) {
        StringBuffer sb = new StringBuffer();
        String es = GlobHelper.escape(separator);
        Matcher ss = Pattern.compile("^([*][*][" + es + "]).*").matcher(pattern);
        if (ss.matches()) {
            pattern = pattern.substring(ss.group(1).length());
            sb.append("(.*[" + es + "])?");
        }
        Matcher st = Pattern.compile(".*([" + es + "][*][*])$").matcher(pattern);
        boolean useSt = false;
        if (st.matches()) {
            pattern = pattern.substring(0, st.start(1));
            useSt = true;
        }
        for (int i = 0; i != pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '?') {
                sb.append("[^" + es + "]");
                continue;
            }
            if (c == '*') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '*') {
                    ++i;
                    sb.append(".*");
                    continue;
                }
                sb.append("[^" + es + "]*");
                continue;
            }
            if (c == '$') {
                sb.append("\\$");
                continue;
            }
            if (Character.isJavaIdentifierPart(c) || Character.isWhitespace(c)) {
                sb.append(c);
                continue;
            }
            sb.append('\\').append(c);
        }
        if (useSt) {
            sb.append("([" + es + "].*)?");
        }
        return Pattern.compile(sb.toString());
    }

    private static String escape(String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i != separator.length(); ++i) {
            char c = separator.charAt(i);
            if ("\\[]&-".indexOf(c) >= 0) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

