/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type;

import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractUserDefinedTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;

public class UserDefinedTypeDeserializer
extends AbstractUserDefinedTypeDeserializer {
    public UserDefinedTypeDeserializer(DebeziumTypeDeserializer deserializer) {
        super(deserializer, Integer.valueOf(48), UserType.class);
    }

    protected List<String> fieldNames(Object abstractType) {
        UserType userType = (UserType)abstractType;
        return userType.fieldNames().stream().map(FieldIdentifier::toString).collect(Collectors.toList());
    }

    protected List<?> fieldTypes(Object abstractType) {
        UserType userType = (UserType)abstractType;
        return userType.fieldTypes();
    }

    protected List<ByteBuffer> bbList(Object abstractType, ByteBuffer bb) {
        UserType userType = (UserType)abstractType;
        UserTypes.Value value = UserTypes.Value.fromSerialized((ByteBuffer)bb, (UserType)userType);
        return value.getElements();
    }

    protected String structName(Object abstractType) {
        UserType userType = (UserType)abstractType;
        return userType.keyspace + "." + userType.getNameAsString();
    }

    protected Object getAbstractTypeInstance(DefaultUserDefinedType userType, List<String> fieldNames, List<?> innerAbstractTypes) {
        ByteBuffer typeNameBuffer = UTF8Type.instance.fromString(userType.getName().toString());
        ArrayList<FieldIdentifier> fieldIdentifiers = new ArrayList<FieldIdentifier>(fieldNames.size());
        for (String fieldName : fieldNames) {
            fieldIdentifiers.add(FieldIdentifier.forInternalString((String)fieldName));
        }
        return new UserType(userType.getKeyspace().toString(), typeNameBuffer, fieldIdentifiers, innerAbstractTypes, !userType.isFrozen());
    }
}

