/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.cassandra.AbstractProcessor;
import io.debezium.connector.cassandra.AbstractSchemaChangeListener;
import io.debezium.connector.cassandra.Cassandra4CommitLogSegmentReader;
import io.debezium.connector.cassandra.Cassandra4SchemaChangeListener;
import io.debezium.connector.cassandra.Cassandra4TypeProvider;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CassandraConnectorTaskTemplate;
import io.debezium.connector.cassandra.CassandraTypeProvider;
import io.debezium.connector.cassandra.CommitLogIdxProcessor;
import io.debezium.connector.cassandra.CommitLogProcessorMetrics;
import io.debezium.connector.cassandra.CommitLogSegmentReader;
import io.debezium.connector.cassandra.ComponentFactory;
import io.debezium.connector.cassandra.ComponentFactoryStandalone;
import io.debezium.connector.cassandra.SchemaChangeListenerProvider;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.cassandra.SchemaLoader;
import io.debezium.connector.cassandra.SourceInfo;
import java.io.File;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.schema.Schema;

public class CassandraConnectorTask {
    public static void main(String[] args) throws Exception {
        CassandraConnectorTaskTemplate.main((String[])args, config -> CassandraConnectorTask.init(config, (ComponentFactory)new ComponentFactoryStandalone()));
    }

    static CassandraConnectorTaskTemplate init(CassandraConnectorConfig config, ComponentFactory factory) {
        CommitLogProcessorMetrics metrics = new CommitLogProcessorMetrics();
        return new CassandraConnectorTaskTemplate(config, (CassandraTypeProvider)new Cassandra4TypeProvider(), (SchemaLoader)new Cassandra4SchemaLoader(), (SchemaChangeListenerProvider)new Cassandra4SchemaChangeListenerProvider(), context -> new AbstractProcessor[]{new CommitLogIdxProcessor(context, metrics, (CommitLogSegmentReader)new Cassandra4CommitLogSegmentReader(context, metrics), new File(DatabaseDescriptor.getCDCLogLocation()))}, factory);
    }

    public static class Cassandra4SchemaLoader
    implements SchemaLoader {
        public void load(String cassandraYaml) {
            cassandraYaml = ((String)cassandraYaml).startsWith("/") ? cassandraYaml : "/" + (String)cassandraYaml;
            System.setProperty("cassandra.config", "file://" + (String)cassandraYaml);
            if (!DatabaseDescriptor.isDaemonInitialized() && !DatabaseDescriptor.isToolInitialized()) {
                DatabaseDescriptor.toolInitialization();
                Schema.instance.loadFromDisk(false);
            }
        }
    }

    public static class Cassandra4SchemaChangeListenerProvider
    implements SchemaChangeListenerProvider {
        public AbstractSchemaChangeListener provide(CassandraConnectorConfig config) {
            return new Cassandra4SchemaChangeListener(config.getLogicalName(), (SourceInfoStructMaker<SourceInfo>)config.getSourceInfoStructMaker(), new SchemaHolder());
        }
    }
}

