/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.type.DefaultSetType;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractTupleTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractUserDefinedTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public abstract class AbstractSetTypeDeserializer
extends CollectionTypeDeserializer {
    public AbstractSetTypeDeserializer(DebeziumTypeDeserializer deserializer, Integer dataType, Class<?> abstractTypeClass) {
        super(deserializer, dataType, abstractTypeClass);
    }

    @Override
    public Object deserialize(Object abstractType, ByteBuffer bb) {
        Set deserializedSet = (Set)super.deserialize(abstractType, bb);
        List<Object> deserializedList = this.processElementsInDeserializedSet(abstractType, deserializedSet);
        return Values.convertToList((Schema)this.getSchemaBuilder(abstractType).build(), deserializedList);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(Object abstractType) {
        Object elementsType = this.getElementsType(abstractType);
        Schema innerSchema = CassandraTypeDeserializer.getSchemaBuilder(elementsType).build();
        return SchemaBuilder.array((Schema)innerSchema).optional();
    }

    @Override
    public Object deserialize(Object abstractType, List<ByteBuffer> bbList) {
        Object elementsType = this.getElementsType(abstractType);
        HashSet<Object> deserializedSet = new HashSet<Object>();
        for (ByteBuffer bb : bbList) {
            deserializedSet.add(CassandraTypeDeserializer.deserialize(elementsType, bb));
        }
        ArrayList deserializedList = new ArrayList(deserializedSet);
        return Values.convertToList((Schema)this.getSchemaBuilder(abstractType).build(), deserializedList);
    }

    private List<Object> processElementsInDeserializedSet(Object abstractType, Set<?> deserializedSet) {
        ArrayList<Object> resultedList;
        Object elementsType = this.getElementsType(abstractType);
        TypeDeserializer elementsTypeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(elementsType);
        if (elementsTypeDeserializer instanceof LogicalTypeDeserializer) {
            resultedList = new ArrayList();
            for (Object element : deserializedSet) {
                Object convertedValue = ((LogicalTypeDeserializer)elementsTypeDeserializer).formatDeserializedValue(elementsType, element);
                resultedList.add(convertedValue);
            }
        } else if (elementsTypeDeserializer instanceof AbstractUserDefinedTypeDeserializer || elementsTypeDeserializer instanceof AbstractTupleTypeDeserializer) {
            resultedList = new ArrayList();
            for (Object element : deserializedSet) {
                Object deserializedElement = elementsTypeDeserializer.deserialize(elementsType, (ByteBuffer)element);
                resultedList.add(deserializedElement);
            }
        } else {
            resultedList = new ArrayList(deserializedSet);
        }
        return resultedList;
    }

    @Override
    public Object getAbstractType(DataType dataType) {
        DefaultSetType setType = (DefaultSetType)dataType;
        DataType innerDataType = setType.getElementType();
        Object innerAbstractType = CassandraTypeDeserializer.getTypeDeserializer(innerDataType).getAbstractType(innerDataType);
        return this.getAbstractTypeInstance(innerAbstractType, !setType.isFrozen());
    }

    protected abstract Object getElementsType(Object var1);

    protected abstract Object getAbstractTypeInstance(Object var1, boolean var2);
}

