/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import io.debezium.connector.cassandra.AbstractCommitLogProcessorTest;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.Record;
import io.debezium.connector.cassandra.TestUtils;
import java.util.List;
import org.junit.Assert;

public class SchemaChangeListenerTest
extends AbstractCommitLogProcessorTest {
    @Override
    public void initialiseData() throws Exception {
        this.createTable("CREATE TABLE %s.%s (a int, b int, PRIMARY KEY ((a), b)) WITH cdc = true;", "test_keyspace", TestUtils.TEST_TABLE_NAME);
        TestUtils.runCql((Statement)QueryBuilder.insertInto((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).value("a", (Term)QueryBuilder.literal((Object)1)).value("b", (Term)QueryBuilder.literal((Object)2)).build());
    }

    @Override
    public void verifyEvents() throws Exception {
        List<Event> events = this.getEvents(1);
        Record insert1 = (Record)events.get(0);
        Assert.assertEquals((Object)Event.EventType.CHANGE_EVENT, (Object)insert1.getEventType());
        Assert.assertEquals((Object)Record.Operation.INSERT, (Object)insert1.getOp());
        Assert.assertTrue((boolean)insert1.getRowData().hasCell("a"));
        Assert.assertTrue((boolean)insert1.getRowData().hasCell("b"));
        Assert.assertFalse((boolean)insert1.getRowData().hasCell("c"));
        TestUtils.runCql((String)String.format("ALTER TABLE %s.%s ADD c int;", "test_keyspace", TestUtils.TEST_TABLE_NAME));
        TestUtils.runCql((Statement)QueryBuilder.insertInto((String)"test_keyspace", (String)TestUtils.TEST_TABLE_NAME).value("a", (Term)QueryBuilder.literal((Object)3)).value("b", (Term)QueryBuilder.literal((Object)4)).value("c", (Term)QueryBuilder.literal((Object)5)).build());
        events = this.getEvents(2);
        Record insert2 = (Record)events.get(1);
        Assert.assertEquals((Object)Event.EventType.CHANGE_EVENT, (Object)insert2.getEventType());
        Assert.assertEquals((Object)Record.Operation.INSERT, (Object)insert2.getOp());
        Assert.assertTrue((boolean)insert2.getRowData().hasCell("a"));
        Assert.assertTrue((boolean)insert2.getRowData().hasCell("b"));
        Assert.assertTrue((boolean)insert2.getRowData().hasCell("c"));
    }
}

