/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import org.gridkit.jvmtool.AbstractThreadDumpSource;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.stacktrace.LegacyStackReader;
import org.gridkit.jvmtool.stacktrace.ReaderProxy;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;
import org.gridkit.jvmtool.stacktrace.StackTraceWriter;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

public class StackDumpCopyCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "stcpy";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new StCpy(host);
    }

    static class DumpInput
    extends AbstractThreadDumpSource {
        @Parameter(names={"-i", "--input"}, description="Input files", required=true, variableArity=true)
        private List<String> inputFiles = new ArrayList<String>();

        public DumpInput(CommandLauncher host) {
            super(host);
        }

        @Override
        protected List<String> inputFiles() {
            return this.inputFiles;
        }
    }

    static class MaskRule {
        String match;
        String replace;

        public MaskRule(String match, String replace) {
            this.match = match;
            this.replace = replace;
        }
    }

    @Parameters(commandDescription="[Stack Copy] Stack dump copy/filtering utility")
    public static class StCpy
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @ParametersDelegate
        private DumpInput input;
        @Parameter(names={"-e", "--empty"}, description="Retain threads without stack trace in dump (ignored by default)")
        private boolean retainEmptyTraces = false;
        @Parameter(names={"--mask"}, variableArity=true, description="One or more masking rules. E.g. com.mycompany:com.somecomplany")
        private List<String> maskingRules = new ArrayList<String>();
        @Parameter(names={"-o", "--output"}, required=true, description="Name of file to write thread dump")
        private String outputFile;
        @Parameter(names={"-ss", "--subsample"}, required=false, description="If below 1.0 some frames will be randomly throwen away. E.g. 0.1 - every 10th will be retained")
        private double subsample = 1.0;
        @Parameter(names={"-tz", "--time-zone"}, required=false, description="Time zone used for timestamps and time ranges")
        private String timeZone = "UTC";
        private int traceCounter;
        private StackTraceWriter writer;
        private List<MaskRule> masking = new ArrayList<MaskRule>();
        private Random rnd = new Random(1L);

        public StCpy(CommandLauncher host) {
            this.host = host;
            this.input = new DumpInput(host);
        }

        @Override
        public void run() {
            try {
                TimeZone tz = TimeZone.getTimeZone(this.timeZone);
                this.input.setTimeZone(tz);
                for (String rule : this.maskingRules) {
                    String[] parts = rule.split("[:]");
                    if (parts.length != 2) {
                        this.host.fail(new String[]{"Bad masking pattern [" + rule + "] should be int [match:replace] format"});
                    }
                    this.masking.add(new MaskRule(parts[0], parts[1]));
                }
                System.out.println("Input files");
                for (String f : this.input.sourceFiles()) {
                    System.out.println("  " + f);
                }
                System.out.println();
                this.openWriter();
                LegacyStackReader rawReader = new LegacyStackReader(this.input.getFilteredReader());
                StackTraceReader.StackTraceReaderDelegate reader = new StackTraceReader.StackTraceReaderDelegate((StackTraceReader)rawReader){
                    final /* synthetic */ StackTraceReader val$rawReader;
                    {
                        this.val$rawReader = stackTraceReader;
                    }

                    protected StackTraceReader getReader() {
                        return this.val$rawReader;
                    }

                    public boolean loadNext() throws IOException {
                        try {
                            return super.loadNext();
                        }
                        catch (IOException e) {
                            System.err.println("Dump file read error: " + e.toString());
                            return false;
                        }
                    }
                };
                if (!reader.isLoaded()) {
                    reader.loadNext();
                }
                ReaderProxy proxy = new ReaderProxy((StackTraceReader)reader){

                    public StackFrameList stackTrace() {
                        return StCpy.this.mask(this.reader.getStackTrace());
                    }
                };
                StackWriterProxy writerProxy = new StackWriterProxy();
                while (reader.isLoaded()) {
                    writerProxy.write((ThreadSnapshot)proxy);
                    reader.loadNext();
                }
                System.out.println(this.traceCounter + " traces written");
                this.writer.close();
            }
            catch (Exception e) {
                this.host.fail("Unexpected error: " + e.toString(), e);
            }
        }

        private void openWriter() throws FileNotFoundException, IOException {
            File file = new File(this.outputFile);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            this.writer = StackTraceCodec.newWriter((OutputStream)new FileOutputStream(file));
            System.out.println("Writing to " + file.getAbsolutePath());
        }

        private StackFrameList mask(StackFrameList stackTrace) {
            if (this.maskingRules.isEmpty()) {
                return stackTrace;
            }
            StackFrame[] frames = stackTrace.toArray();
            for (int i = 0; i != frames.length; ++i) {
                frames[i] = this.mask(frames[i]);
            }
            return new StackFrameArray(frames);
        }

        private StackFrame mask(StackFrame stackFrame) {
            for (MaskRule rule : this.masking) {
                if (!stackFrame.getClassName().startsWith(rule.match)) continue;
                String cn = stackFrame.getClassName();
                String nn = rule.replace + cn.substring(rule.match.length());
                StackFrame ff = new StackFrame("", nn, stackFrame.getMethodName(), stackFrame.getSourceFile(), stackFrame.getLineNumber());
                return ff;
            }
            return stackFrame;
        }

        private class StackWriterProxy
        implements StackTraceWriter {
            public void write(ThreadSnapshot snap) throws IOException {
                if ((snap.stackTrace() == null || snap.stackTrace().isEmpty()) && !StCpy.this.retainEmptyTraces) {
                    return;
                }
                if (StCpy.this.rnd.nextDouble() > StCpy.this.subsample) {
                    return;
                }
                ++StCpy.this.traceCounter;
                StCpy.this.writer.write(snap);
            }

            public void close() {
                StCpy.this.writer.close();
            }
        }
    }
}

