/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.attach;

import java.io.File;
import java.io.FileNotFoundException;
import org.gridkit.lab.jvm.attach.AttachManager;

public class HeapDumper {
    public static String dumpLive(int pid, String targetFile, long timeoutMs) {
        try {
            File file = new File(targetFile).getCanonicalFile();
            file.getParentFile().mkdirs();
            if (!file.getParentFile().isDirectory()) {
                throw new FileNotFoundException("Cannot create: " + file.getPath());
            }
            file.delete();
            Object[] plive = new String[]{file.getPath(), "-live"};
            return AttachManager.getHeapDump(pid, plive, timeoutMs);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String dumpAll(int pid, String targetFile, long timeoutMs) {
        try {
            File file = new File(targetFile).getCanonicalFile();
            file.getParentFile().mkdirs();
            if (!file.getParentFile().isDirectory()) {
                throw new FileNotFoundException("Cannot create: " + file.getPath());
            }
            file.delete();
            Object[] plive = new String[]{file.getPath()};
            return AttachManager.getHeapDump(pid, plive, timeoutMs);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

