/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;

public class MD5Digest {
    private static final ThreadLocal<MessageDigest> localMD5Digest = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            return FBUtilities.newMessageDigest("MD5");
        }

        @Override
        public MessageDigest get() {
            MessageDigest digest = (MessageDigest)super.get();
            digest.reset();
            return digest;
        }
    };
    public final byte[] bytes;
    private final int hashCode;

    private MD5Digest(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = Arrays.hashCode(bytes);
    }

    public static MD5Digest wrap(byte[] digest) {
        return new MD5Digest(digest);
    }

    public static MD5Digest compute(byte[] toHash) {
        return new MD5Digest(localMD5Digest.get().digest(toHash));
    }

    public static MD5Digest compute(String toHash) {
        return MD5Digest.compute(toHash.getBytes(StandardCharsets.UTF_8));
    }

    public ByteBuffer byteBuffer() {
        return ByteBuffer.wrap(this.bytes);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof MD5Digest)) {
            return false;
        }
        MD5Digest that = (MD5Digest)o;
        return FBUtilities.compareUnsigned(this.bytes, that.bytes, 0, 0, this.bytes.length, that.bytes.length) == 0;
    }

    public String toString() {
        return Hex.bytesToHex(this.bytes);
    }

    public static MessageDigest threadLocalMD5Digest() {
        return localMD5Digest.get();
    }
}

