/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.NoSuchElementException;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.BasePartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.schema.TableMetadata;

public class EmptyIterators {
    public static UnfilteredPartitionIterator unfilteredPartition(TableMetadata metadata) {
        return new EmptyUnfilteredPartitionIterator(metadata);
    }

    public static PartitionIterator partition() {
        return EmptyPartitionIterator.instance;
    }

    public static UnfilteredRowIterator unfilteredRow(TableMetadata metadata, DecoratedKey partitionKey, boolean isReverseOrder, Row staticRow, DeletionTime partitionDeletion) {
        RegularAndStaticColumns columns = RegularAndStaticColumns.NONE;
        if (!staticRow.isEmpty()) {
            columns = new RegularAndStaticColumns(Columns.from(staticRow.columns()), Columns.NONE);
        } else {
            staticRow = Rows.EMPTY_STATIC_ROW;
        }
        if (partitionDeletion.isLive()) {
            partitionDeletion = DeletionTime.LIVE;
        }
        return new EmptyUnfilteredRowIterator(columns, metadata, partitionKey, isReverseOrder, staticRow, partitionDeletion);
    }

    public static UnfilteredRowIterator unfilteredRow(TableMetadata metadata, DecoratedKey partitionKey, boolean isReverseOrder) {
        return new EmptyUnfilteredRowIterator(RegularAndStaticColumns.NONE, metadata, partitionKey, isReverseOrder, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE);
    }

    public static RowIterator row(TableMetadata metadata, DecoratedKey partitionKey, boolean isReverseOrder) {
        return new EmptyRowIterator(metadata, partitionKey, isReverseOrder, Rows.EMPTY_STATIC_ROW);
    }

    private static class EmptyRowIterator
    extends EmptyBaseRowIterator<Row>
    implements RowIterator {
        public EmptyRowIterator(TableMetadata metadata, DecoratedKey partitionKey, boolean isReverseOrder, Row staticRow) {
            super(RegularAndStaticColumns.NONE, metadata, partitionKey, isReverseOrder, staticRow);
        }
    }

    private static class EmptyUnfilteredRowIterator
    extends EmptyBaseRowIterator<Unfiltered>
    implements UnfilteredRowIterator {
        final DeletionTime partitionLevelDeletion;

        public EmptyUnfilteredRowIterator(RegularAndStaticColumns columns, TableMetadata metadata, DecoratedKey partitionKey, boolean isReverseOrder, Row staticRow, DeletionTime partitionLevelDeletion) {
            super(columns, metadata, partitionKey, isReverseOrder, staticRow);
            this.partitionLevelDeletion = partitionLevelDeletion;
        }

        @Override
        public boolean isEmpty() {
            return this.partitionLevelDeletion == DeletionTime.LIVE && super.isEmpty();
        }

        @Override
        public DeletionTime partitionLevelDeletion() {
            return this.partitionLevelDeletion;
        }

        @Override
        public EncodingStats stats() {
            return EncodingStats.NO_STATS;
        }
    }

    private static class EmptyBaseRowIterator<U extends Unfiltered>
    implements BaseRowIterator<U> {
        final RegularAndStaticColumns columns;
        final TableMetadata metadata;
        final DecoratedKey partitionKey;
        final boolean isReverseOrder;
        final Row staticRow;

        EmptyBaseRowIterator(RegularAndStaticColumns columns, TableMetadata metadata, DecoratedKey partitionKey, boolean isReverseOrder, Row staticRow) {
            this.columns = columns;
            this.metadata = metadata;
            this.partitionKey = partitionKey;
            this.isReverseOrder = isReverseOrder;
            this.staticRow = staticRow;
        }

        @Override
        public TableMetadata metadata() {
            return this.metadata;
        }

        @Override
        public boolean isReverseOrder() {
            return this.isReverseOrder;
        }

        @Override
        public RegularAndStaticColumns columns() {
            return this.columns;
        }

        @Override
        public DecoratedKey partitionKey() {
            return this.partitionKey;
        }

        @Override
        public Row staticRow() {
            return this.staticRow;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isEmpty() {
            return this.staticRow == Rows.EMPTY_STATIC_ROW;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public U next() {
            throw new NoSuchElementException();
        }
    }

    private static class EmptyPartitionIterator
    extends EmptyBasePartitionIterator<RowIterator>
    implements PartitionIterator {
        public static final EmptyPartitionIterator instance = new EmptyPartitionIterator();

        private EmptyPartitionIterator() {
        }
    }

    private static class EmptyUnfilteredPartitionIterator
    extends EmptyBasePartitionIterator<UnfilteredRowIterator>
    implements UnfilteredPartitionIterator {
        final TableMetadata metadata;

        public EmptyUnfilteredPartitionIterator(TableMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public TableMetadata metadata() {
            return this.metadata;
        }
    }

    private static class EmptyBasePartitionIterator<R extends BaseRowIterator<?>>
    implements BasePartitionIterator<R> {
        EmptyBasePartitionIterator() {
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public R next() {
            throw new NoSuchElementException();
        }
    }
}

