/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.schema.Diff;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class DropIndexStatement
extends AlterSchemaStatement {
    private final String indexName;
    private final boolean ifExists;

    public DropIndexStatement(String keyspaceName, String indexName, boolean ifExists) {
        super(keyspaceName);
        this.indexName = indexName;
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        TableMetadata table;
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        TableMetadata tableMetadata = table = null == keyspace ? null : (TableMetadata)keyspace.findIndexedTable(this.indexName).orElse(null);
        if (null == table) {
            if (this.ifExists) {
                return schema;
            }
            throw DropIndexStatement.ire("Index '%s.%s' doesn't exist'", this.keyspaceName, this.indexName);
        }
        TableMetadata newTable = table.withSwapped(table.indexes.without(this.indexName));
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.tables.withSwapped(newTable)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        assert (diff.altered.size() == 1);
        KeyspaceMetadata.KeyspaceDiff ksDiff = (KeyspaceMetadata.KeyspaceDiff)diff.altered.get(0);
        assert (ksDiff.tables.altered.size() == 1);
        Diff.Altered tableDiff = (Diff.Altered)ksDiff.tables.altered.iterator().next();
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, ((TableMetadata)tableDiff.after).name);
    }

    @Override
    public void authorize(ClientState client) {
        KeyspaceMetadata keyspace = Schema.instance.getKeyspaceMetadata(this.keyspaceName);
        if (null == keyspace) {
            return;
        }
        keyspace.findIndexedTable(this.indexName).ifPresent(t -> client.ensureTablePermission(this.keyspaceName, t.name, Permission.ALTER));
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_INDEX, this.keyspaceName, this.indexName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.indexName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private final boolean ifExists;

        public Raw(QualifiedName name, boolean ifExists) {
            this.name = name;
            this.ifExists = ifExists;
        }

        @Override
        public DropIndexStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            return new DropIndexStatement(keyspaceName, this.name.getName(), this.ifExists);
        }
    }
}

