/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal.actions.snapshotting;

import io.debezium.pipeline.signal.actions.snapshotting.AdditionalCondition;
import java.util.ArrayList;
import java.util.List;

public class SnapshotConfiguration {
    private List<String> dataCollections;
    private List<AdditionalCondition> additionalConditions;
    private String surrogateKey;

    public List<String> getDataCollections() {
        return this.dataCollections;
    }

    public List<AdditionalCondition> getAdditionalConditions() {
        return this.additionalConditions;
    }

    public String getSurrogateKey() {
        return this.surrogateKey;
    }

    public static final class Builder {
        private List<String> dataCollections;
        private final List<AdditionalCondition> additionalConditions = new ArrayList<AdditionalCondition>();
        private String surrogateKey;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder dataCollections(List<String> dataCollections) {
            this.dataCollections = dataCollections;
            return this;
        }

        public Builder addCondition(AdditionalCondition additionalCondition) {
            this.additionalConditions.add(additionalCondition);
            return this;
        }

        public Builder surrogateKey(String surrogateKey) {
            this.surrogateKey = surrogateKey;
            return this;
        }

        public SnapshotConfiguration build() {
            SnapshotConfiguration snapshotConfiguration = new SnapshotConfiguration();
            snapshotConfiguration.surrogateKey = this.surrogateKey;
            snapshotConfiguration.dataCollections = this.dataCollections;
            snapshotConfiguration.additionalConditions = this.additionalConditions;
            return snapshotConfiguration;
        }
    }
}

