/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.type.DefaultListType;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractTupleTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.AbstractUserDefinedTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public abstract class AbstractListTypeDeserializer
extends CollectionTypeDeserializer {
    public AbstractListTypeDeserializer(DebeziumTypeDeserializer deserializer, Integer dataType, Class<?> abstractTypeClass) {
        super(deserializer, dataType, abstractTypeClass);
    }

    @Override
    public Object deserialize(Object abstractType, ByteBuffer bb) {
        List<?> deserializedList = (List<?>)super.deserialize(abstractType, bb);
        deserializedList = this.processElementsInDeserializedList(abstractType, deserializedList);
        return Values.convertToList((Schema)this.getSchemaBuilder(abstractType).build(), deserializedList);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(Object abstractType) {
        Object elementsType = this.getElementsType(abstractType);
        Schema innerSchema = CassandraTypeDeserializer.getSchemaBuilder(elementsType).build();
        return SchemaBuilder.array((Schema)innerSchema).optional();
    }

    @Override
    public Object deserialize(Object abstractType, List<ByteBuffer> bbList) {
        Object elementsType = this.getElementsType(abstractType);
        ArrayList<Object> deserializedList = new ArrayList<Object>(bbList.size());
        for (ByteBuffer bb : bbList) {
            deserializedList.add(CassandraTypeDeserializer.deserialize(elementsType, bb));
        }
        return Values.convertToList((Schema)this.getSchemaBuilder(abstractType).build(), deserializedList);
    }

    private List<?> processElementsInDeserializedList(Object abstractType, List<?> deserializedList) {
        List<Object> resultedList;
        Object elementsType = this.getElementsType(abstractType);
        TypeDeserializer elementsTypeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(elementsType);
        if (elementsTypeDeserializer instanceof LogicalTypeDeserializer) {
            resultedList = new ArrayList();
            for (Object element : deserializedList) {
                Object formattedElement = ((LogicalTypeDeserializer)elementsTypeDeserializer).formatDeserializedValue(elementsType, element);
                resultedList.add(formattedElement);
            }
        } else if (elementsTypeDeserializer instanceof AbstractUserDefinedTypeDeserializer || elementsTypeDeserializer instanceof AbstractTupleTypeDeserializer) {
            resultedList = new ArrayList();
            for (Object element : deserializedList) {
                Object deserializedElement = elementsTypeDeserializer.deserialize(elementsType, (ByteBuffer)element);
                resultedList.add(deserializedElement);
            }
        } else {
            resultedList = deserializedList;
        }
        return resultedList;
    }

    @Override
    public Object getAbstractType(DataType dataType) {
        DefaultListType listType = (DefaultListType)dataType;
        DataType innerDataType = listType.getElementType();
        Object innerAbstractType = CassandraTypeDeserializer.getTypeDeserializer(innerDataType).getAbstractType(innerDataType);
        return this.getAbstractTypeInstance(innerAbstractType, !listType.isFrozen());
    }

    protected abstract Object getElementsType(Object var1);

    protected abstract Object getAbstractTypeInstance(Object var1, boolean var2);
}

