/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.driver.shaded.netty.util.concurrent.EventExecutor;
import com.datastax.oss.driver.shaded.netty.util.concurrent.ScheduledFuture;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class Reconnection {
    private static final Logger LOG = LoggerFactory.getLogger(Reconnection.class);
    private final String logPrefix;
    private final EventExecutor executor;
    private final Supplier<ReconnectionPolicy.ReconnectionSchedule> scheduleSupplier;
    private final Callable<CompletionStage<Boolean>> reconnectionTask;
    private final Runnable onStart;
    private final Runnable onStop;
    private State state = State.STOPPED;
    private ReconnectionPolicy.ReconnectionSchedule reconnectionSchedule;
    private ScheduledFuture<CompletionStage<Boolean>> nextAttempt;

    public Reconnection(String logPrefix, EventExecutor executor, Supplier<ReconnectionPolicy.ReconnectionSchedule> scheduleSupplier, Callable<CompletionStage<Boolean>> reconnectionTask, Runnable onStart, Runnable onStop) {
        this.logPrefix = logPrefix;
        this.executor = executor;
        this.scheduleSupplier = scheduleSupplier;
        this.reconnectionTask = reconnectionTask;
        this.onStart = onStart;
        this.onStop = onStop;
    }

    public Reconnection(String logPrefix, EventExecutor executor, Supplier<ReconnectionPolicy.ReconnectionSchedule> scheduleSupplier, Callable<CompletionStage<Boolean>> reconnectionTask) {
        this(logPrefix, executor, scheduleSupplier, reconnectionTask, () -> {}, () -> {});
    }

    public boolean isRunning() {
        assert (this.executor.inEventLoop());
        return this.state != State.STOPPED;
    }

    public void start() {
        this.start(null);
    }

    public void start(ReconnectionPolicy.ReconnectionSchedule customSchedule) {
        assert (this.executor.inEventLoop());
        switch (this.state) {
            case SCHEDULED: 
            case ATTEMPT_IN_PROGRESS: {
                break;
            }
            case STOP_AFTER_CURRENT: {
                this.state = State.ATTEMPT_IN_PROGRESS;
                break;
            }
            case STOPPED: {
                this.reconnectionSchedule = customSchedule == null ? this.scheduleSupplier.get() : customSchedule;
                this.onStart.run();
                this.scheduleNextAttempt();
            }
        }
    }

    public void reconnectNow(boolean forceIfStopped) {
        assert (this.executor.inEventLoop());
        if (this.state == State.ATTEMPT_IN_PROGRESS || this.state == State.STOP_AFTER_CURRENT) {
            LOG.debug("[{}] reconnectNow and current attempt was still running, letting it complete", (Object)this.logPrefix);
            if (this.state == State.STOP_AFTER_CURRENT) {
                this.state = State.ATTEMPT_IN_PROGRESS;
            }
        } else if (this.state == State.STOPPED && !forceIfStopped) {
            LOG.debug("[{}] reconnectNow(false) while stopped, nothing to do", (Object)this.logPrefix);
        } else {
            assert (this.state == State.SCHEDULED || this.state == State.STOPPED && forceIfStopped);
            LOG.debug("[{}] Forcing next attempt now", (Object)this.logPrefix);
            if (this.nextAttempt != null) {
                this.nextAttempt.cancel(true);
            }
            try {
                this.onNextAttemptStarted(this.reconnectionTask.call());
            }
            catch (Exception e) {
                Loggers.warnWithException(LOG, "[{}] Uncaught error while starting reconnection attempt", this.logPrefix, e);
                this.scheduleNextAttempt();
            }
        }
    }

    public void stop() {
        assert (this.executor.inEventLoop());
        switch (this.state) {
            case STOP_AFTER_CURRENT: 
            case STOPPED: {
                break;
            }
            case ATTEMPT_IN_PROGRESS: {
                this.state = State.STOP_AFTER_CURRENT;
                break;
            }
            case SCHEDULED: {
                this.reallyStop();
            }
        }
    }

    private void reallyStop() {
        LOG.debug("[{}] Stopping reconnection", (Object)this.logPrefix);
        this.state = State.STOPPED;
        if (this.nextAttempt != null) {
            this.nextAttempt.cancel(true);
            this.nextAttempt = null;
        }
        this.onStop.run();
        this.reconnectionSchedule = null;
    }

    private void scheduleNextAttempt() {
        assert (this.executor.inEventLoop());
        this.state = State.SCHEDULED;
        if (this.reconnectionSchedule == null) {
            this.reconnectionSchedule = this.scheduleSupplier.get();
        }
        Duration nextInterval = this.reconnectionSchedule.nextDelay();
        LOG.debug("[{}] Scheduling next reconnection in {}", (Object)this.logPrefix, (Object)nextInterval);
        this.nextAttempt = this.executor.schedule(this.reconnectionTask, nextInterval.toNanos(), TimeUnit.NANOSECONDS);
        this.nextAttempt.addListener(f -> {
            if (f.isSuccess()) {
                this.onNextAttemptStarted((CompletionStage)f.getNow());
            } else if (!f.isCancelled()) {
                Loggers.warnWithException(LOG, "[{}] Uncaught error while starting reconnection attempt", this.logPrefix, f.cause());
                this.scheduleNextAttempt();
            }
        });
    }

    private void onNextAttemptStarted(CompletionStage<Boolean> futureOutcome) {
        assert (this.executor.inEventLoop());
        this.state = State.ATTEMPT_IN_PROGRESS;
        futureOutcome.whenCompleteAsync(this::onNextAttemptCompleted, this.executor).exceptionally(UncaughtExceptions::log);
    }

    private void onNextAttemptCompleted(Boolean success, Throwable error) {
        assert (this.executor.inEventLoop());
        if (success.booleanValue()) {
            LOG.debug("[{}] Reconnection successful", (Object)this.logPrefix);
            this.reallyStop();
        } else {
            if (error != null && !(error instanceof CancellationException)) {
                Loggers.warnWithException(LOG, "[{}] Uncaught error while starting reconnection attempt", this.logPrefix, error);
            }
            if (this.state == State.STOP_AFTER_CURRENT) {
                this.reallyStop();
            } else {
                assert (this.state == State.ATTEMPT_IN_PROGRESS);
                this.scheduleNextAttempt();
            }
        }
    }

    private static enum State {
        STOPPED,
        SCHEDULED,
        ATTEMPT_IN_PROGRESS,
        STOP_AFTER_CURRENT;

    }
}

