/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import io.debezium.connector.cassandra.Cassandra4TypeProvider;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CassandraTypeDeserializerTest {
    private static final Charset CHARSET = Charset.forName("UTF-8");

    @BeforeClass
    public static void beforeAll() {
        Cassandra4TypeProvider provider = new Cassandra4TypeProvider();
        CassandraTypeDeserializer.init((List)provider.deserializers(), (CassandraTypeDeserializer.DecimalMode)CassandraTypeDeserializer.DecimalMode.DOUBLE, (CassandraTypeDeserializer.VarIntMode)CassandraTypeDeserializer.VarIntMode.LONG, (Function)provider.baseTypeForReversedType());
    }

    @Test
    public void testAscii() {
        String expectedAscii = "some text";
        ByteBuffer serializedAscii = AsciiType.instance.decompose((Object)expectedAscii);
        Object deserializedAscii = CassandraTypeDeserializer.deserialize((Object)AsciiType.instance, (ByteBuffer)serializedAscii);
        Assert.assertEquals((Object)"some text", (Object)deserializedAscii);
        deserializedAscii = CassandraTypeDeserializer.deserialize((DataType)DataTypes.ASCII, (ByteBuffer)serializedAscii);
        Assert.assertEquals((Object)"some text", (Object)deserializedAscii);
    }

    @Test
    public void testBoolean() {
        Boolean expectedBoolean = true;
        ByteBuffer serializedBoolean = BooleanType.instance.decompose((Object)expectedBoolean);
        Object deserializedBoolean = CassandraTypeDeserializer.deserialize((Object)BooleanType.instance, (ByteBuffer)serializedBoolean);
        Assert.assertEquals((Object)expectedBoolean, (Object)deserializedBoolean);
        deserializedBoolean = CassandraTypeDeserializer.deserialize((DataType)DataTypes.BOOLEAN, (ByteBuffer)serializedBoolean);
        Assert.assertEquals((Object)expectedBoolean, (Object)deserializedBoolean);
    }

    @Test
    public void testBytes() {
        ByteBuffer expectedBytes = ByteBuffer.wrap("some random stuff here".getBytes(CHARSET));
        ByteBuffer serializedBytes = BytesType.instance.decompose((Object)expectedBytes);
        Object deserializedBytes = CassandraTypeDeserializer.deserialize((Object)BytesType.instance, (ByteBuffer)serializedBytes);
        Assert.assertEquals((Object)expectedBytes, (Object)deserializedBytes);
        deserializedBytes = CassandraTypeDeserializer.deserialize((DataType)DataTypes.BLOB, (ByteBuffer)serializedBytes);
        Assert.assertEquals((Object)expectedBytes, (Object)deserializedBytes);
    }

    @Test
    public void testByteType() {
        Byte expectedByte = Byte.valueOf("9");
        ByteBuffer serializedByte = ByteType.instance.decompose((Object)expectedByte);
        Object deserializedByte = CassandraTypeDeserializer.deserialize((Object)ByteType.instance, (ByteBuffer)serializedByte);
        Assert.assertEquals((Object)expectedByte, (Object)deserializedByte);
        deserializedByte = CassandraTypeDeserializer.deserialize((DataType)DataTypes.TINYINT, (ByteBuffer)serializedByte);
        Assert.assertEquals((Object)expectedByte, (Object)deserializedByte);
    }

    @Test
    public void testCounterColumnType() {
        Long expectedCounterColumnType = 42L;
        ByteBuffer serializedCounter = CounterColumnType.instance.decompose(Long.valueOf(42L));
        Object deserializedCounter = CassandraTypeDeserializer.deserialize((Object)CounterColumnType.instance, (ByteBuffer)serializedCounter);
        Assert.assertEquals((Object)expectedCounterColumnType, (Object)deserializedCounter);
        deserializedCounter = CassandraTypeDeserializer.deserialize((DataType)DataTypes.COUNTER, (ByteBuffer)serializedCounter);
        Assert.assertEquals((Object)expectedCounterColumnType, (Object)deserializedCounter);
    }

    @Test
    public void testDecimalType() {
        BigDecimal expectedDecimal = BigDecimal.valueOf(Math.PI);
        ByteBuffer serializedDecimal = DecimalType.instance.decompose((Object)expectedDecimal);
        Object deserializedDecimalAsDouble = CassandraTypeDeserializer.deserialize((Object)DecimalType.instance, (ByteBuffer)serializedDecimal);
        Assert.assertEquals((Object)expectedDecimal.doubleValue(), (Object)deserializedDecimalAsDouble);
        deserializedDecimalAsDouble = CassandraTypeDeserializer.deserialize((DataType)DataTypes.DECIMAL, (ByteBuffer)serializedDecimal);
        Assert.assertEquals((Object)expectedDecimal.doubleValue(), (Object)deserializedDecimalAsDouble);
        CassandraTypeDeserializer.setDecimalMode((CassandraTypeDeserializer.DecimalMode)CassandraTypeDeserializer.DecimalMode.PRECISE);
        Object deserializedDecimalAsStruct = CassandraTypeDeserializer.deserialize((Object)DecimalType.instance, (ByteBuffer)serializedDecimal);
        Schema decimalSchema = CassandraTypeDeserializer.getSchemaBuilder((Object)DecimalType.instance).build();
        Struct expectedDecimalStruct = new Struct(decimalSchema).put("value", (Object)expectedDecimal.unscaledValue().toByteArray()).put("scale", (Object)expectedDecimal.scale());
        Assert.assertEquals((Object)expectedDecimalStruct, (Object)deserializedDecimalAsStruct);
        deserializedDecimalAsStruct = CassandraTypeDeserializer.deserialize((DataType)DataTypes.DECIMAL, (ByteBuffer)serializedDecimal);
        Assert.assertEquals((Object)expectedDecimalStruct, (Object)deserializedDecimalAsStruct);
        CassandraTypeDeserializer.setDecimalMode((CassandraTypeDeserializer.DecimalMode)CassandraTypeDeserializer.DecimalMode.STRING);
        Object deserializedDecimalAsString = CassandraTypeDeserializer.deserialize((Object)DecimalType.instance, (ByteBuffer)serializedDecimal);
        Assert.assertEquals((Object)expectedDecimal.toPlainString(), (Object)deserializedDecimalAsString);
        deserializedDecimalAsString = CassandraTypeDeserializer.deserialize((DataType)DataTypes.DECIMAL, (ByteBuffer)serializedDecimal);
        Assert.assertEquals((Object)expectedDecimal.toPlainString(), (Object)deserializedDecimalAsString);
    }

    @Test
    public void testDoubleType() {
        Double expectedDouble = 100.5;
        ByteBuffer serializedDouble = DoubleType.instance.decompose((Object)expectedDouble);
        Object deserializedDouble = CassandraTypeDeserializer.deserialize((Object)DoubleType.instance, (ByteBuffer)serializedDouble);
        Assert.assertEquals((Object)expectedDouble, (Object)deserializedDouble);
        deserializedDouble = CassandraTypeDeserializer.deserialize((DataType)DataTypes.DOUBLE, (ByteBuffer)serializedDouble);
        Assert.assertEquals((Object)expectedDouble, (Object)deserializedDouble);
    }

    @Test
    public void testDurationType() {
        Duration sourceDuration = Duration.newInstance((int)1, (int)3, (long)500L);
        long expectedNanoDuration = 33L * ChronoUnit.DAYS.getDuration().toNanos() + 500L;
        ByteBuffer serializedDuration = DurationType.instance.decompose((Object)sourceDuration);
        Object deserializedDuration = CassandraTypeDeserializer.deserialize((Object)DurationType.instance, (ByteBuffer)serializedDuration);
        Assert.assertEquals((Object)expectedNanoDuration, (Object)deserializedDuration);
        deserializedDuration = CassandraTypeDeserializer.deserialize((DataType)DataTypes.DURATION, (ByteBuffer)serializedDuration);
        Assert.assertEquals((Object)expectedNanoDuration, (Object)deserializedDuration);
    }

    @Test
    public void testFloatType() {
        Float expectedFloat = Float.valueOf(66.6f);
        ByteBuffer serializedFloat = FloatType.instance.decompose((Object)expectedFloat);
        Object deserializedFloat = CassandraTypeDeserializer.deserialize((Object)FloatType.instance, (ByteBuffer)serializedFloat);
        Assert.assertEquals((Object)expectedFloat, (Object)deserializedFloat);
        deserializedFloat = CassandraTypeDeserializer.deserialize((DataType)DataTypes.FLOAT, (ByteBuffer)serializedFloat);
        Assert.assertEquals((Object)expectedFloat, (Object)deserializedFloat);
    }

    @Test
    public void testInetAddressType() throws UnknownHostException {
        InetAddress sourceInetAddress = InetAddress.getLocalHost();
        String expectedInetAddress = "/" + sourceInetAddress.getHostAddress();
        ByteBuffer serializedInetAddress = InetAddressType.instance.decompose((Object)sourceInetAddress);
        Object deserializedInetAddress = CassandraTypeDeserializer.deserialize((Object)InetAddressType.instance, (ByteBuffer)serializedInetAddress);
        Assert.assertEquals((Object)expectedInetAddress, (Object)deserializedInetAddress);
        deserializedInetAddress = CassandraTypeDeserializer.deserialize((DataType)DataTypes.INET, (ByteBuffer)serializedInetAddress);
        Assert.assertEquals((Object)expectedInetAddress, (Object)deserializedInetAddress);
    }

    @Test
    public void testInt32Type() {
        Integer expectedInteger = 8;
        ByteBuffer serializedInt32 = Int32Type.instance.decompose((Object)expectedInteger);
        Object deserializedInt32 = CassandraTypeDeserializer.deserialize((Object)Int32Type.instance, (ByteBuffer)serializedInt32);
        Assert.assertEquals((Object)expectedInteger, (Object)deserializedInt32);
        deserializedInt32 = CassandraTypeDeserializer.deserialize((DataType)DataTypes.INT, (ByteBuffer)serializedInt32);
        Assert.assertEquals((Object)expectedInteger, (Object)deserializedInt32);
    }

    @Test
    public void testIntegerType() {
        BigInteger expectedInteger = BigInteger.valueOf(8L);
        ByteBuffer serializedVarInt = IntegerType.instance.decompose((Object)expectedInteger);
        Object deserializedVarIntAsLong = CassandraTypeDeserializer.deserialize((Object)IntegerType.instance, (ByteBuffer)serializedVarInt);
        Assert.assertEquals((Object)expectedInteger.longValue(), (Object)deserializedVarIntAsLong);
        deserializedVarIntAsLong = CassandraTypeDeserializer.deserialize((DataType)DataTypes.VARINT, (ByteBuffer)serializedVarInt);
        Assert.assertEquals((Object)expectedInteger.longValue(), (Object)deserializedVarIntAsLong);
        CassandraTypeDeserializer.setVarIntMode((CassandraTypeDeserializer.VarIntMode)CassandraTypeDeserializer.VarIntMode.PRECISE);
        Object deserializedVarIntAsBigDecimal = CassandraTypeDeserializer.deserialize((Object)IntegerType.instance, (ByteBuffer)serializedVarInt);
        Assert.assertEquals((Object)new BigDecimal(expectedInteger), (Object)deserializedVarIntAsBigDecimal);
        deserializedVarIntAsBigDecimal = CassandraTypeDeserializer.deserialize((DataType)DataTypes.VARINT, (ByteBuffer)serializedVarInt);
        Assert.assertEquals((Object)new BigDecimal(expectedInteger), (Object)deserializedVarIntAsBigDecimal);
        CassandraTypeDeserializer.setVarIntMode((CassandraTypeDeserializer.VarIntMode)CassandraTypeDeserializer.VarIntMode.STRING);
        Object deserializedVarIntAsString = CassandraTypeDeserializer.deserialize((Object)IntegerType.instance, (ByteBuffer)serializedVarInt);
        Assert.assertEquals((Object)expectedInteger.toString(), (Object)deserializedVarIntAsString);
        deserializedVarIntAsString = CassandraTypeDeserializer.deserialize((DataType)DataTypes.VARINT, (ByteBuffer)serializedVarInt);
        Assert.assertEquals((Object)expectedInteger.toString(), (Object)deserializedVarIntAsString);
    }

    @Test
    public void testListType() {
        ArrayList<Integer> expectedList = new ArrayList<Integer>();
        expectedList.add(1);
        expectedList.add(3);
        expectedList.add(5);
        ListType nonFrozenListType = ListType.getInstance((AbstractType)Int32Type.instance, (boolean)true);
        ByteBuffer serializedList = nonFrozenListType.decompose(expectedList);
        Object deserializedList = CassandraTypeDeserializer.deserialize((Object)nonFrozenListType, (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
        deserializedList = CassandraTypeDeserializer.deserialize((DataType)DataTypes.listOf((DataType)DataTypes.INT), (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
        ListType frozenListType = ListType.getInstance((AbstractType)Int32Type.instance, (boolean)false);
        serializedList = frozenListType.decompose(expectedList);
        deserializedList = CassandraTypeDeserializer.deserialize((Object)frozenListType, (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
        deserializedList = CassandraTypeDeserializer.deserialize((DataType)DataTypes.frozenListOf((DataType)DataTypes.INT), (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
    }

    @Test
    public void testLongType() {
        Long expectedLong = 8L;
        ByteBuffer serializedLong = LongType.instance.decompose((Object)expectedLong);
        Object deserializedLong = CassandraTypeDeserializer.deserialize((Object)LongType.instance, (ByteBuffer)serializedLong);
        Assert.assertEquals((Object)expectedLong, (Object)deserializedLong);
        deserializedLong = CassandraTypeDeserializer.deserialize((DataType)DataTypes.BIGINT, (ByteBuffer)serializedLong);
        Assert.assertEquals((Object)expectedLong, (Object)deserializedLong);
    }

    @Test
    public void testMapType() {
        HashMap<String, Double> expectedMap = new HashMap<String, Double>();
        expectedMap.put("foo", 1.0);
        expectedMap.put("bar", 50.0);
        MapType nonFrozenMapType = MapType.getInstance((AbstractType)AsciiType.instance, (AbstractType)DoubleType.instance, (boolean)true);
        ByteBuffer serializedMap = nonFrozenMapType.decompose(expectedMap);
        Object deserializedMap = CassandraTypeDeserializer.deserialize((Object)nonFrozenMapType, (ByteBuffer)serializedMap);
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
        deserializedMap = CassandraTypeDeserializer.deserialize((DataType)DataTypes.mapOf((DataType)DataTypes.ASCII, (DataType)DataTypes.DOUBLE), (ByteBuffer)serializedMap);
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
        MapType frozenMapType = MapType.getInstance((AbstractType)AsciiType.instance, (AbstractType)DoubleType.instance, (boolean)false);
        serializedMap = frozenMapType.decompose(expectedMap);
        deserializedMap = CassandraTypeDeserializer.deserialize((Object)frozenMapType, (ByteBuffer)serializedMap);
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
        deserializedMap = CassandraTypeDeserializer.deserialize((DataType)DataTypes.frozenMapOf((DataType)DataTypes.ASCII, (DataType)DataTypes.DOUBLE), (ByteBuffer)serializedMap);
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
    }

    @Test
    public void testMapTypeNonStringKeys() {
        HashMap<Integer, Float> sourceMap = new HashMap<Integer, Float>();
        sourceMap.put(1, Float.valueOf(1.5f));
        sourceMap.put(2, Float.valueOf(3.1414f));
        HashMap<Integer, Float> expectedMap = new HashMap<Integer, Float>();
        expectedMap.put(1, Float.valueOf(1.5f));
        expectedMap.put(2, Float.valueOf(3.1414f));
        MapType mapType = MapType.getInstance((AbstractType)Int32Type.instance, (AbstractType)FloatType.instance, (boolean)true);
        ByteBuffer serializedMap = mapType.decompose(sourceMap);
        Object deserializedMap = CassandraTypeDeserializer.deserialize((Object)mapType, (ByteBuffer)serializedMap);
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
        deserializedMap = CassandraTypeDeserializer.deserialize((DataType)DataTypes.mapOf((DataType)DataTypes.INT, (DataType)DataTypes.FLOAT), (ByteBuffer)serializedMap);
        Assert.assertEquals(expectedMap, (Object)deserializedMap);
    }

    @Test
    public void testSetType() {
        HashSet<Float> sourceSet = new HashSet<Float>();
        sourceSet.add(Float.valueOf(42.0f));
        sourceSet.add(Float.valueOf(123.0f));
        SetType nonFrozenSetType = SetType.getInstance((AbstractType)FloatType.instance, (boolean)true);
        ByteBuffer serializedSet = nonFrozenSetType.decompose(sourceSet);
        Collection deserializedSet = (Collection)CassandraTypeDeserializer.deserialize((Object)nonFrozenSetType, (ByteBuffer)serializedSet);
        Assert.assertTrue((boolean)sourceSet.containsAll(deserializedSet));
        Assert.assertTrue((boolean)deserializedSet.containsAll(sourceSet));
        deserializedSet = (Collection)CassandraTypeDeserializer.deserialize((DataType)DataTypes.setOf((DataType)DataTypes.FLOAT), (ByteBuffer)serializedSet);
        Assert.assertTrue((boolean)sourceSet.containsAll(deserializedSet));
        Assert.assertTrue((boolean)deserializedSet.containsAll(sourceSet));
        SetType frozenSetType = SetType.getInstance((AbstractType)FloatType.instance, (boolean)false);
        serializedSet = frozenSetType.decompose(sourceSet);
        deserializedSet = (Collection)CassandraTypeDeserializer.deserialize((Object)frozenSetType, (ByteBuffer)serializedSet);
        Assert.assertTrue((boolean)sourceSet.containsAll(deserializedSet));
        Assert.assertTrue((boolean)deserializedSet.containsAll(sourceSet));
        deserializedSet = (Collection)CassandraTypeDeserializer.deserialize((DataType)DataTypes.frozenSetOf((DataType)DataTypes.FLOAT), (ByteBuffer)serializedSet);
        Assert.assertTrue((boolean)sourceSet.containsAll(deserializedSet));
        Assert.assertTrue((boolean)deserializedSet.containsAll(sourceSet));
    }

    @Test
    public void testShortType() {
        Short expectedShort = 2;
        ByteBuffer serializedShort = ShortType.instance.decompose((Object)expectedShort);
        Object deserializedShort = CassandraTypeDeserializer.deserialize((Object)ShortType.instance, (ByteBuffer)serializedShort);
        Assert.assertEquals((Object)expectedShort, (Object)deserializedShort);
        deserializedShort = CassandraTypeDeserializer.deserialize((DataType)DataTypes.SMALLINT, (ByteBuffer)serializedShort);
        Assert.assertEquals((Object)expectedShort, (Object)deserializedShort);
    }

    @Test
    public void testSimpleDateType() {
        Integer expectedDate = 17953;
        ByteBuffer serializedDate = SimpleDateType.instance.decompose((Object)expectedDate);
        Object deserializedShort = CassandraTypeDeserializer.deserialize((Object)SimpleDateType.instance, (ByteBuffer)serializedDate);
        Assert.assertEquals((Object)expectedDate, (Object)deserializedShort);
        deserializedShort = CassandraTypeDeserializer.deserialize((DataType)DataTypes.DATE, (ByteBuffer)serializedDate);
        Assert.assertEquals((Object)expectedDate, (Object)deserializedShort);
    }

    @Test
    public void testTimeType() {
        Long expectedTime = 30L;
        ByteBuffer serializedTime = TimeType.instance.decompose((Object)expectedTime);
        Object deserializedTime = CassandraTypeDeserializer.deserialize((Object)TimeType.instance, (ByteBuffer)serializedTime);
        Assert.assertEquals((Object)expectedTime, (Object)deserializedTime);
        deserializedTime = CassandraTypeDeserializer.deserialize((DataType)DataTypes.TIME, (ByteBuffer)serializedTime);
        Assert.assertEquals((Object)expectedTime, (Object)deserializedTime);
    }

    @Test
    public void testTimestampType() {
        Date timestamp = new Date();
        Long expectedLongTimestamp = timestamp.getTime();
        ByteBuffer serializedTimestamp = TimestampType.instance.decompose((Object)timestamp);
        Object deserializedTimestamp = CassandraTypeDeserializer.deserialize((Object)TimestampType.instance, (ByteBuffer)serializedTimestamp);
        Assert.assertEquals((Object)expectedLongTimestamp, (Object)deserializedTimestamp);
        deserializedTimestamp = CassandraTypeDeserializer.deserialize((DataType)DataTypes.TIMESTAMP, (ByteBuffer)serializedTimestamp);
        Assert.assertEquals((Object)expectedLongTimestamp, (Object)deserializedTimestamp);
    }

    @Test
    public void testTimeUUIDType() {
        UUID timeUUID = UUID.randomUUID();
        ByteBuffer serializedTimeUUID = TimeUUIDType.instance.decompose((Object)timeUUID);
        Object deserializedTimeUUID = CassandraTypeDeserializer.deserialize((Object)TimeUUIDType.instance, (ByteBuffer)serializedTimeUUID);
        Assert.assertEquals((Object)timeUUID.toString(), (Object)deserializedTimeUUID);
        deserializedTimeUUID = CassandraTypeDeserializer.deserialize((DataType)DataTypes.TIMEUUID, (ByteBuffer)serializedTimeUUID);
        Assert.assertEquals((Object)timeUUID.toString(), (Object)deserializedTimeUUID);
    }

    @Test
    public void testTupleType() {
        ArrayList<Object> innerAbstractTypes = new ArrayList<Object>(2);
        innerAbstractTypes.add(AsciiType.instance);
        innerAbstractTypes.add(ShortType.instance);
        TupleType tupleType = new TupleType(innerAbstractTypes);
        String sourceTupleString = "foo:1";
        ByteBuffer serializedTuple = tupleType.fromString(sourceTupleString);
        Schema tupleSchema = CassandraTypeDeserializer.getSchemaBuilder((Object)tupleType).build();
        Struct expectedTuple = new Struct(tupleSchema).put("field1", (Object)"foo").put("field2", (Object)1);
        Object deserializedTuple = CassandraTypeDeserializer.deserialize((Object)tupleType, (ByteBuffer)serializedTuple);
        Assert.assertEquals((Object)expectedTuple, (Object)deserializedTuple);
        deserializedTuple = CassandraTypeDeserializer.deserialize((DataType)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.ASCII, DataTypes.SMALLINT}), (ByteBuffer)serializedTuple);
        Assert.assertEquals((Object)expectedTuple, (Object)deserializedTuple);
    }

    @Test
    public void testUserType() {
        ByteBuffer expectedTypeName = ByteBuffer.wrap("FooType".getBytes(Charset.defaultCharset()));
        ArrayList<FieldIdentifier> expectedFieldIdentifiers = new ArrayList<FieldIdentifier>();
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("asciiField".getBytes(Charset.defaultCharset()))));
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("doubleField".getBytes(Charset.defaultCharset()))));
        expectedFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("durationField".getBytes(Charset.defaultCharset()))));
        ArrayList<Object> expectedFieldTypes = new ArrayList<Object>();
        expectedFieldTypes.add(AsciiType.instance);
        expectedFieldTypes.add(DoubleType.instance);
        expectedFieldTypes.add(DurationType.instance);
        UserType userType = new UserType("barspace", expectedTypeName, expectedFieldIdentifiers, expectedFieldTypes, true);
        Schema userSchema = CassandraTypeDeserializer.getSchemaBuilder((Object)userType).build();
        long expectedNanoDuration = 32L * ChronoUnit.DAYS.getDuration().toNanos() + 3L;
        Struct expectedUserTypeData = new Struct(userSchema).put("asciiField", (Object)"foobar").put("doubleField", (Object)1.5).put("durationField", (Object)expectedNanoDuration);
        HashMap<String, Object> jsonObject = new HashMap<String, Object>(3);
        jsonObject.put("\"asciiField\"", "foobar");
        jsonObject.put("\"doubleField\"", 1.5);
        jsonObject.put("\"durationField\"", DurationType.instance.getSerializer().toString((Object)Duration.newInstance((int)1, (int)2, (long)3L)));
        Term userTypeObject = userType.fromJSONObject(jsonObject);
        ByteBuffer buffer = userTypeObject.bindAndGet(QueryOptions.DEFAULT);
        ByteBuffer serializedUserTypeObject = userType.decompose((Object)buffer);
        Object deserializedUserTypeObject = CassandraTypeDeserializer.deserialize((Object)userType, (ByteBuffer)serializedUserTypeObject);
        Assert.assertEquals((Object)expectedUserTypeData, (Object)deserializedUserTypeObject);
        DefaultUserDefinedType userDefinedType = new DefaultUserDefinedType(CqlIdentifier.fromCql((String)"\"barspace\""), CqlIdentifier.fromCql((String)"\"FooType\""), false, Arrays.asList(CqlIdentifier.fromCql((String)"\"asciiField\""), CqlIdentifier.fromCql((String)"\"doubleField\""), CqlIdentifier.fromCql((String)"\"durationField\"")), Arrays.asList(DataTypes.ASCII, DataTypes.DOUBLE, DataTypes.DURATION));
        deserializedUserTypeObject = CassandraTypeDeserializer.deserialize((DataType)userDefinedType, (ByteBuffer)serializedUserTypeObject);
        Assert.assertEquals((Object)expectedUserTypeData, (Object)deserializedUserTypeObject);
    }

    @Test
    public void testUTF8Type() {
        String expectedUTF8 = "Fourscore and seven years ago";
        ByteBuffer serializedUTF8 = UTF8Type.instance.decompose((Object)expectedUTF8);
        Object deserializedUTF8 = CassandraTypeDeserializer.deserialize((Object)UTF8Type.instance, (ByteBuffer)serializedUTF8);
        Assert.assertEquals((Object)expectedUTF8, (Object)deserializedUTF8);
        deserializedUTF8 = CassandraTypeDeserializer.deserialize((DataType)DataTypes.TEXT, (ByteBuffer)serializedUTF8);
        Assert.assertEquals((Object)expectedUTF8, (Object)deserializedUTF8);
    }

    @Test
    public void testUUIDType() {
        UUID uuid = UUID.randomUUID();
        String expectedFixedUUID = uuid.toString();
        ByteBuffer serializedUUID = UUIDType.instance.decompose((Object)uuid);
        Object deserializedUUID = CassandraTypeDeserializer.deserialize((Object)UUIDType.instance, (ByteBuffer)serializedUUID);
        Assert.assertEquals((Object)expectedFixedUUID, (Object)deserializedUUID);
        deserializedUUID = CassandraTypeDeserializer.deserialize((DataType)DataTypes.UUID, (ByteBuffer)serializedUUID);
        Assert.assertEquals((Object)expectedFixedUUID, (Object)deserializedUUID);
    }

    @Test
    public void testReversedType() {
        Date timestamp = new Date();
        Long expectedLongTimestamp = timestamp.getTime();
        ByteBuffer serializedTimestamp = TimestampType.instance.decompose((Object)timestamp);
        ReversedType reversedTimeStampType = ReversedType.getInstance((AbstractType)TimestampType.instance);
        Object deserializedTimestamp = CassandraTypeDeserializer.deserialize((Object)reversedTimeStampType, (ByteBuffer)serializedTimestamp);
        Assert.assertEquals((Object)expectedLongTimestamp, (Object)deserializedTimestamp);
    }

    @Test
    public void testListUUIDType() {
        ArrayList<UUID> originalList = new ArrayList<UUID>();
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        UUID uuid3 = UUID.randomUUID();
        originalList.add(uuid1);
        originalList.add(uuid2);
        originalList.add(uuid3);
        ArrayList<String> expectedList = new ArrayList<String>();
        String expectedUuidStr1 = uuid1.toString();
        String expectedUuidStr2 = uuid2.toString();
        String expectedUuidStr3 = uuid3.toString();
        expectedList.add(expectedUuidStr1);
        expectedList.add(expectedUuidStr2);
        expectedList.add(expectedUuidStr3);
        ListType frozenListType = ListType.getInstance((AbstractType)UUIDType.instance, (boolean)false);
        ByteBuffer serializedList = frozenListType.decompose(originalList);
        Object deserializedList = CassandraTypeDeserializer.deserialize((Object)frozenListType, (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
        deserializedList = CassandraTypeDeserializer.deserialize((DataType)DataTypes.listOf((DataType)DataTypes.UUID), (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
    }

    @Test
    public void testListUserType() {
        ByteBuffer userTypeName = ByteBuffer.wrap("FooType".getBytes(Charset.defaultCharset()));
        ArrayList<FieldIdentifier> userTypeFieldIdentifiers = new ArrayList<FieldIdentifier>();
        userTypeFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("asciiField".getBytes(Charset.defaultCharset()))));
        userTypeFieldIdentifiers.add(new FieldIdentifier(ByteBuffer.wrap("setField".getBytes(Charset.defaultCharset()))));
        SetType frozenSetType = SetType.getInstance((AbstractType)AsciiType.instance, (boolean)false);
        ArrayList<Object> userFieldTypes = new ArrayList<Object>();
        userFieldTypes.add(AsciiType.instance);
        userFieldTypes.add(frozenSetType);
        UserType userType = new UserType("barspace", userTypeName, userTypeFieldIdentifiers, userFieldTypes, false);
        Schema userTypeSchema = CassandraTypeDeserializer.getSchemaBuilder((Object)userType).build();
        HashSet<String> sourceSet = new HashSet<String>();
        sourceSet.add("text1");
        sourceSet.add("text2");
        Struct expectedUserTypeData1 = new Struct(userTypeSchema).put("asciiField", (Object)"foobar1").put("setField", new ArrayList(sourceSet));
        Struct expectedUserTypeData2 = new Struct(userTypeSchema).put("asciiField", (Object)"foobar2").put("setField", new ArrayList(sourceSet));
        ArrayList<Struct> expectedList = new ArrayList<Struct>();
        expectedList.add(expectedUserTypeData1);
        expectedList.add(expectedUserTypeData2);
        HashMap<String, Object> jsonObject1 = new HashMap<String, Object>(2);
        jsonObject1.put("\"asciiField\"", "foobar1");
        jsonObject1.put("\"setField\"", new ArrayList(sourceSet));
        Term userTypeObject1 = userType.fromJSONObject(jsonObject1);
        ByteBuffer buffer1 = userTypeObject1.bindAndGet(QueryOptions.DEFAULT);
        ByteBuffer serializedUserTypeObject1 = userType.decompose((Object)buffer1);
        HashMap<String, Object> jsonObject2 = new HashMap<String, Object>(2);
        jsonObject2.put("\"asciiField\"", "foobar2");
        jsonObject2.put("\"setField\"", new ArrayList(sourceSet));
        Term userTypeObject2 = userType.fromJSONObject(jsonObject2);
        ByteBuffer buffer2 = userTypeObject2.bindAndGet(QueryOptions.DEFAULT);
        ByteBuffer serializedUserTypeObject2 = userType.decompose((Object)buffer2);
        ArrayList<ByteBuffer> originalList = new ArrayList<ByteBuffer>();
        originalList.add(serializedUserTypeObject1);
        originalList.add(serializedUserTypeObject2);
        ListType frozenListType = ListType.getInstance((AbstractType)userType, (boolean)false);
        ByteBuffer serializedList = frozenListType.decompose(originalList);
        Object deserializedList = CassandraTypeDeserializer.deserialize((Object)frozenListType, (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
        DefaultUserDefinedType userDefinedType = new DefaultUserDefinedType(CqlIdentifier.fromCql((String)"\"barspace\""), CqlIdentifier.fromCql((String)"\"FooType\""), true, Arrays.asList(CqlIdentifier.fromCql((String)"\"asciiField\""), CqlIdentifier.fromCql((String)"\"setField\"")), Arrays.asList(DataTypes.ASCII, DataTypes.frozenSetOf((DataType)DataTypes.ASCII)));
        deserializedList = CassandraTypeDeserializer.deserialize((DataType)DataTypes.frozenListOf((DataType)userDefinedType), (ByteBuffer)serializedList);
        Assert.assertEquals(expectedList, (Object)deserializedList);
    }
}

