/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import java.util.HashMap;
import java.util.HashSet;

public class EnumSchemaDiff {
    static void compare(Context ctx, EnumElement original, EnumElement update) {
        HashMap<Integer, Object> originalByTag = new HashMap<Integer, Object>();
        for (Object enumer : original.getConstants()) {
            originalByTag.put(enumer.getTag(), enumer);
        }
        HashMap<Integer, EnumConstantElement> updateByTag = new HashMap<Integer, EnumConstantElement>();
        for (EnumConstantElement enumer : update.getConstants()) {
            updateByTag.put(enumer.getTag(), enumer);
        }
        HashSet allTags = new HashSet(originalByTag.keySet());
        allTags.addAll(updateByTag.keySet());
        for (Integer tag : allTags) {
            Context.PathScope pathScope = ctx.enterPath(tag.toString());
            Throwable throwable = null;
            try {
                EnumConstantElement originalEnumConstant = (EnumConstantElement)originalByTag.get(tag);
                EnumConstantElement updateEnumConstant = (EnumConstantElement)updateByTag.get(tag);
                if (updateEnumConstant == null) {
                    ctx.addDifference(Difference.Type.ENUM_CONST_REMOVED);
                    continue;
                }
                if (originalEnumConstant == null) {
                    ctx.addDifference(Difference.Type.ENUM_CONST_ADDED);
                    continue;
                }
                if (originalEnumConstant.getName().equals(updateEnumConstant.getName())) continue;
                ctx.addDifference(Difference.Type.ENUM_CONST_CHANGED);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pathScope == null) continue;
                if (throwable != null) {
                    try {
                        pathScope.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pathScope.close();
            }
        }
    }
}

