/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import java.time.Duration;

public interface OffsetFlushPolicy {
    public boolean shouldFlush(Duration var1, long var2);

    public static OffsetFlushPolicy always() {
        return new AlwaysFlushOffsetPolicy();
    }

    public static OffsetFlushPolicy periodic(Duration offsetFlushInterval, long maxOffsetFlushSize) {
        return new PeriodicFlushOffsetPolicy(offsetFlushInterval, maxOffsetFlushSize);
    }

    public static class AlwaysFlushOffsetPolicy
    implements OffsetFlushPolicy {
        @Override
        public boolean shouldFlush(Duration timeSinceLastFlush, long numOfRecordsSinceLastFlush) {
            return true;
        }
    }

    public static class PeriodicFlushOffsetPolicy
    implements OffsetFlushPolicy {
        private final Duration offsetFlushInterval;
        private final long maxOffsetFlushSize;

        PeriodicFlushOffsetPolicy(Duration offsetFlushInterval, long maxOffsetFlushSize) {
            this.offsetFlushInterval = offsetFlushInterval;
            this.maxOffsetFlushSize = maxOffsetFlushSize;
        }

        @Override
        public boolean shouldFlush(Duration timeSinceLastFlush, long numOfRecordsSinceLastFlush) {
            return timeSinceLastFlush.compareTo(this.offsetFlushInterval) >= 0 || numOfRecordsSinceLastFlush >= this.maxOffsetFlushSize;
        }
    }
}

