/*
 * Decompiled with CFR 0.152.
 */
package jflex.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import jflex.core.LexParse;
import jflex.core.LexScan;
import jflex.core.NFA;
import jflex.core.OptionUtils;
import jflex.dfa.DFA;
import jflex.dfa.DfaFactory;
import jflex.exceptions.GeneratorException;
import jflex.exceptions.MacroException;
import jflex.generator.Emitter;
import jflex.generator.Emitters;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;
import jflex.performance.Timer;
import jflex.scanner.ScannerException;

public class LexGenerator {
    private final File inputFile;
    private DFA dfa;
    private final Timer totalTime = new Timer();

    public LexGenerator(File inputFile) {
        this.inputFile = inputFile;
        if (Options.encoding == null) {
            OptionUtils.setDefaultOptions();
        }
    }

    public String generate() {
        String string;
        Out.resetCounters();
        Timer time = new Timer();
        this.totalTime.start();
        InputStreamReader inputReader = new InputStreamReader(Files.newInputStream(Paths.get(this.inputFile.toString(), new String[0]), new OpenOption[0]), Options.encoding);
        try {
            Out.println(ErrorMessages.READING, this.inputFile.toString());
            LexScan scanner = new LexScan(inputReader);
            scanner.setFile(this.inputFile);
            LexParse parser = new LexParse(scanner);
            NFA nfa = (NFA)parser.parse().value;
            Out.checkErrors();
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.NFA_IS) + Out.NL + nfa + Out.NL);
            }
            if (Options.dot) {
                nfa.writeDot(Emitter.normalize("nfa.dot", null));
            }
            Out.println(ErrorMessages.NFA_STATES, nfa.numStates());
            time.start();
            this.dfa = DfaFactory.createFromNfa(nfa);
            time.stop();
            Out.time(ErrorMessages.DFA_TOOK, time);
            this.dfa.checkActions(scanner, parser);
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.DFA_IS) + Out.NL + this.dfa + Out.NL);
            }
            if (Options.dot) {
                this.dfa.writeDot(Emitter.normalize("dfa-big.dot", null));
            }
            Out.checkErrors();
            time.start();
            int numStatesBefore = this.dfa.numStates();
            this.dfa.minimize();
            Out.println(String.format("%d states before minimization, %d states in minimized DFA", numStatesBefore, this.dfa.numStates()));
            time.stop();
            Out.time(ErrorMessages.MIN_TOOK, time);
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.MIN_DFA_IS) + Out.NL + this.dfa);
            }
            if (Options.dot) {
                this.dfa.writeDot(Emitter.normalize("dfa-min.dot", null));
            }
            time.start();
            Emitter emitter = Emitters.createFileEmitter(this.inputFile, parser, this.dfa);
            emitter.emit();
            time.stop();
            Out.time(ErrorMessages.WRITE_TOOK, time);
            this.totalTime.stop();
            Out.time(ErrorMessages.TOTAL_TIME, this.totalTime);
            string = emitter.outputFileName;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)inputReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ScannerException e) {
                Out.error(e.file, e.message, e.line, e.column);
                throw new GeneratorException(e);
            }
            catch (MacroException e) {
                Out.error(e.getMessage());
                throw new GeneratorException(e);
            }
            catch (IOException e) {
                Out.error(ErrorMessages.IO_ERROR, e.toString());
                throw new GeneratorException(e);
            }
            catch (OutOfMemoryError e) {
                Out.error(ErrorMessages.OUT_OF_MEMORY);
                throw new GeneratorException(e);
            }
            catch (GeneratorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GeneratorException(e, true);
            }
        }
        ((Reader)inputReader).close();
        return string;
    }

    public int minimizedDfaStatesCount() {
        LexGenerator.checkNotNull(this.dfa, "DFA doesn't exist. Call generate() first.");
        LexGenerator.checkState(this.dfa.isMinimized(), "DFA is not minimized. Call minimize() first.");
        return this.dfa.numStates();
    }

    private static Object checkNotNull(Object object, String msg) {
        if (object == null) {
            throw new NullPointerException(msg);
        }
        return object;
    }

    private static void checkState(boolean state, String msg) {
        if (!state) {
            throw new IllegalStateException(msg);
        }
    }
}

