/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.event.ErrorEvent;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.event.SimpleCounterCollection;
import org.gridkit.jvmtool.event.SimpleErrorEvent;
import org.gridkit.jvmtool.event.SimpleTagCollection;
import org.gridkit.jvmtool.event.TagCollection;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;

public class LegacyThreadEventReader
implements EventReader<Event> {
    private final StackTraceReader reader;
    private final Proxy proxy = new Proxy();
    private ErrorEvent error;
    private boolean goNext;

    public LegacyThreadEventReader(StackTraceReader reader) {
        this.reader = reader;
        if (reader.isLoaded()) {
            this.proxy.init();
        }
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<Event, M> morpher) {
        return MorphingEventReader.morph(this, morpher);
    }

    @Override
    public boolean hasNext() {
        if (this.error != null) {
            return !this.goNext;
        }
        try {
            if (this.goNext || !this.reader.isLoaded()) {
                this.goNext = false;
                if (this.reader.loadNext()) {
                    this.proxy.init();
                }
            }
            return this.reader.isLoaded();
        }
        catch (IOException e) {
            this.error = new SimpleErrorEvent(e);
            return true;
        }
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.goNext = true;
        return this.error == null ? this.proxy : this.error;
    }

    @Override
    public Event peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.error == null ? this.proxy : this.error;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }

    @Override
    public void dispose() {
    }

    private class Proxy
    implements ThreadSnapshotEvent {
        private SimpleCounterCollection counters = new SimpleCounterCollection();
        private SimpleTagCollection tags = new SimpleTagCollection();

        private Proxy() {
        }

        public void init() {
            this.counters.clear();
            this.counters.setAll(LegacyThreadEventReader.this.reader.getCounters());
            if (LegacyThreadEventReader.this.reader.getThreadId() >= 0L) {
                this.counters.set("thread.javaId", LegacyThreadEventReader.this.reader.getThreadId());
            }
            this.tags.clear();
            if (LegacyThreadEventReader.this.reader.getThreadName() != null) {
                this.tags.put("thread.javaName", LegacyThreadEventReader.this.reader.getThreadName());
            }
            if (LegacyThreadEventReader.this.reader.getThreadState() != null) {
                this.tags.put("thread.javaState", LegacyThreadEventReader.this.reader.getThreadState().toString());
            }
        }

        @Override
        public long threadId() {
            return LegacyThreadEventReader.this.reader.getThreadId();
        }

        @Override
        public String threadName() {
            return LegacyThreadEventReader.this.reader.getThreadName();
        }

        @Override
        public Thread.State threadState() {
            return LegacyThreadEventReader.this.reader.getThreadState();
        }

        @Override
        public StackFrameList stackTrace() {
            return LegacyThreadEventReader.this.reader.getStackTrace();
        }

        @Override
        public long timestamp() {
            return LegacyThreadEventReader.this.reader.getTimestamp();
        }

        @Override
        public CounterCollection counters() {
            return this.counters;
        }

        @Override
        public TagCollection tags() {
            return this.tags;
        }
    }
}

